'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;

//收藏的用户
var ForumFollowUserSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	to: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_follow_user'
});

module.exports = mongoose.model('ForumFollowUser', ForumFollowUserSchema);