'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//消息
var ForumMessageSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { //发消息者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	fromUsername: { //发消息帐号
		type: String,
		require: false
	},
	fromNickName: { //发消息昵称
		type: String,
		require: false
	},
	to: [{ //收消息者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	}],
	title: { //标题
		type: String,
		require: true
	},
	type:{//类型 
		type: Number,
		require: false
	},
	content: { //话题内容
		type: String
	},
	status: { //状态，0显示，1屏蔽
		type: Number,
		require: true,
		default: 0
	}, 
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}

}, {
	'collection': 'pisns_forum_message'
});


module.exports = mongoose.model('ForumMessage', ForumMessageSchema);