'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//建议
var ForumSuggestionSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { //发消息者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	title: { //标题
		type: String,
		require: true
	},
	content: { //话题内容
		type: String
	},
	status: { //状态，1显示，2屏蔽，3 删除 
		type: Number,
		require: true,
		default: 1
	}, 
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}

}, {
	'collection': 'pisns_forum_suggestion'
});


module.exports = mongoose.model('ForumSuggestion', ForumSuggestionSchema);