'use strict';

var mongoose = require('mongoose'),
    Schema = mongoose.Schema;
//用户设置荣誉头衔时间线
var ForumUserHonorTimeLineSchema = new Schema({
    ent_code: {
        type: Number,
        require: true,
        index: true
    },
    user: { //用户
        type: Schema.Types.ObjectId,
        require: true,
        index: true,
        ref: 'ForumUser'
    },
    honor: { //荣誉
        type: Schema.Types.ObjectId,
        ref: 'ForumHonorTitle',
        index: true
    },
    created: {
        type: Date,
        required: true,
        default: Date.now
    }

}, {
    'collection': 'pisns_forum_user_honor_time_line'
});


module.exports = mongoose.model('ForumUserHonorTimeLine', ForumUserHonorTimeLineSchema);
