'use strict';
var mongoose = require('mongoose');
var ForumFollowThread = mongoose.model('ForumFollowThread');

exports.create = function(entity, callback) {
    var forum = new ForumFollowThread(entity);
    forum.save(function(err, doc) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, doc);
        }
    });
};
 
exports.remove = function(conditions, callback) {
    ForumFollowThread.remove(conditions, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//获取数量
function countAll(conditions, callback) {
    ForumFollowThread.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}

//分页查询
exports.find = function(pageNo, pageSize, conditions, sort, callback) {
    countAll(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);

            var sortby = "-_id";
            if (sort) {
                sortby = sort;
            }

            ForumFollowThread.find(conditions).skip(skip).limit(pageSize).sort(sortby).exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err, null);
                } else {
                    var obj = {};
                    obj.total = count;
                    obj.pageNo = pageNo;
                    obj.pageSize = pageSize;
                    obj.items = docs;
                    callback(null, obj);
                }
            });
        }
    });
};

//获取列表
exports.findAll = function(conditions, sort, fields, callback) {
    var sortby = "-_id";
    if (sort) {
        sortby = sort;
    }
    ForumFollowThread.find(conditions).select(fields).sort(sortby).exec(function(err, docs) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, docs);
        }
    });
};

exports.isNotFollow = function(conditions, callback) {
    countAll(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else if (count > 0) {
            callback(1);
        } else {
            callback(null);
        }
    });
};

//获取列表数量
exports.count = function(conditions, callback) {
    countAll(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
};



//获取列表
exports.findWithThread = function(conditions, subFields, callback) {
    ForumFollowThread.find(conditions).populate({
        path: 'thread',
        select: subFields
    }).exec(function(err, docs) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, docs);
        }
    });
};
