'use strict';
var _=require('lodash');
var async=require('async');

/**=====<1.缓存实现开始==========**/
function toCache(dur, k, v) {
    if(v){
        redis.hset(dur.ns,k,1, function(err) {
            if(!err){
                redis.expire(dur.ns, dur.dur);
                var str = '';
                try{
                    str = JSON.stringify(v);
                }catch(e){
                    console.log(e);
                }
                if(str){
                    redis.set(k,str,function(err){
                        if(!err){
                            redis.expire(k, dur.dur);
                        }
                    });
                }
            }
        });
    }
}

function fromCache(dur,k,cb){
    redis.hget(dur.ns,k, function(err,hit){
        if(err){
            console.log(err);
            return cb();
        }
        if(!hit){
            return cb();
        }
        redis.get(k, function(err,data){
            if(err){
                console.log(err);
                return cb();
            }
            if(!data){
                return cb();
            }
            var obj = null;
            try{
                obj = JSON.parse(data);
            }catch(e){
                console.log(err);
            }
            cb(null,obj);
        });
    });
}

function loadAndCacheData(dur, key, fn, args, cb) {
    var _cacheData = _.partial(toCache, dur, key);
    //async.compose(_cacheData, fn).apply(null, args.concat(cb));相同实现
    fn.apply(null,args.concat(function(){
        var err = arguments[0];
        var datas = Array.prototype.slice.call(arguments, 0);
        if(!err){//缓存数据
            _cacheData(datas);
        }
        //调用业务逻辑
        cb.apply(null,datas);
    }));
}

function getKey(ns, args) {
    var key = Array.prototype.join.call(arguments,'_');
    return 'cacheable_'+key;
}

function withCache(dur, keyBuilder, fn) {
    var args, cb, key;
    args = Array.prototype.slice.call(arguments, 3, -1);
    cb   = _.last(arguments);             // the callback function
    key  = keyBuilder.apply(null, [dur.ns].concat(args));  // compute cache key
    fromCache(dur,key, function(err, datas) {
        if (err) return cb(err);
        if (datas) {// cache hit
            // console.log('cache hit');
            cb.apply(null, datas);
        }else {// cache missed
            console.log('cache missed');
            loadAndCacheData.call(null, dur, key, fn, args, cb);
        }
    });
}

function cacheable(fn,opts){
    return _.partial(withCache, opts, getKey, fn);
}
/**=====缓存实现结束==========>**/


/**<=====2.清空缓存实现开始=============**/
function clear(ns){
    redis.del(ns,function(err){
        if(err){
            console.log(err);
        }
    });
}

function withClear(ns, fn) {
    var args = Array.prototype.slice.call(arguments, 2);
    clear(ns);//先清缓存然后调用具体业务
    fn.apply(null, args);
}

function clearable(fn,ns){
    return _.partial(withClear, ns, fn);
}
/**=====清空缓存实现结束=============>**/


module.exports = {
    /**
     * 声明式缓存
     * 使用方式：（前提是fn的最后一个参数是回调函数,回调函数第一个参数是err类似function(err,data1,data2,data3){}）
     * var cache = require('./cacheable');
     * var service  = require('../service/service1');
     * cache.cacheable(service,    'method1',       { ns: 'forum.service.service1', dur: 10000 });
     * @param m ：module对象
     * @param fn ：要缓存的函数名
     * @param opts { ns: '', dur: 1000 }
     * ns:缓存命名空间，dur:过期时间
     */
    cacheable:function(m,fn,opts){
        if(!m){
            throw 'm 不能为空';
        }
        if(!fn){
            throw 'fn 不能为空';
        }
        if(!m[fn]){
            throw 'm 不存在fn函数';
        }
        if(!opts){
            throw 'opts 不能为空';
        }
        if(!opts.ns){
            throw 'opts.ns 不能为空';
        }
        if(!opts.dur || isNaN(opts.dur)){//默认缓存一小时
            opts.dur = 60 * 60;
        }
        m[fn] = cacheable(m[fn], opts);
    },
    /**
     * 当调用某个方法时自动清空缓存
     * 使用方式：
     * var cache = require('./cacheable');
     * var service  = require('../service/service1');
     * cache.clear(service,    'method1','forum.service.service1');
     * @param m ：module对象
     * @param fn ：函数名
     * @param 缓存命名空间
     */
    clear:function(m,fn,ns){
        if(!m){
            throw 'm 不能为空';
        }
        if(!fn){
            throw 'fn 不能为空';
        }
        if(!m[fn]){
            throw 'm 不存在fn函数';
        }
        if(!ns){
            throw 'ns 不能为空';
        }
        m[fn] = clearable(m[fn], ns);
    }
}