'use strict';

var redis=global.redis;
var expire = 60*30;

//缓存数量
var ThreadRedisCount = 50;

var _ = require('lodash');
var then = require('thenjs');
var forumThreadService=require('../service/forumThreadService');
var redisPraiseLog=require('./redisPraiseLog');
var util=require('./util');

var RefreshFlag = true;

var tyhread_redis_salt = '_tyhread_redis_salt';

var sort = {
	new_recommend:-1,
	new_recommend_order_idx:-1,
	new_recommend_time:-1,
	top:-1,
	top_order_idx:-1,
	topTime:-1,
	tag_top:-1,
	tag_topTime:-1,
	quality:-1,
	created:-1
};

function getKey(ent_code, salt){
	var key = ent_code + salt;
	return key;
}

function setToRedis(ent_code,salt,value){
	var key = getKey(ent_code,salt);
	if(!redis){
		console.log('redis error');
		return 'error'
	}
	redis.set(key, value, function(error, res){
		redis.expire(key, expire);
		return 'success'
	});
}

function getEsenceThreads(ent_code, salt,callback){
    var today = new Date();
    var conditions = {
        ent_code: ent_code,
        level: 1,
        status: 1,
        new_recommend: 1,
		$or: [{
			isEvent: {
				$ne:1
			}
		}, {
            isEvent: 1,
            'event.eventStartTime' : {$lte : today}
        }]
    };
    forumThreadService.getThreadWithNotPopulateComment(conditions, 1, ThreadRedisCount, sort, function(err, results) {
        if (err) {
            console.error(err);
	        callback(err);
        } else {
            util.loadLevel(ent_code, results.items, function() {
                setToRedis(ent_code, salt ,JSON.stringify(results));
                callback(null);
            });
        }
    });
};

exports.get=function(ent_code, callback){
	var key = getKey(ent_code, tyhread_redis_salt);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.get(key, function(error, res){
		if(!res){
			//不存在，先获取再返回
			getEsenceThreads(ent_code, tyhread_redis_salt,function(err){
				redis.get(key, function(error, res){
					return callback && callback(error, res.split(","));
			    });
			});
		}else{
			return callback && callback(error, res);
		}
    });
};

exports.set=function(ent_code, salt, value, callback){
	var key = getKey(ent_code, salt);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.set(key, value, function(error, res){
		redis.expire(key, expire);
		return callback && callback(error, 'success');
	});
};

exports.clear = function(ent_code,salt,callback){
	var key = getKey(ent_code, salt);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.del(key, function(error, res){
		return callback && callback(error, !!res);
    });
}; 

//获取缓存列表
exports.getRedisEsenceThreads = function(ent_code, callback){
	var key = getKey(ent_code, tyhread_redis_salt);
	getEsenceThreads(ent_code, tyhread_redis_salt, function(err){
		redis.get(key, function(error, res){
			return callback && callback(error, res.split(","));
	    });
	});
};

//获取缓存数值
exports.getThreadRedisCount = function(){
	return ThreadRedisCount;
};

//更新缓存列表
exports.updateRedisEsenceThreads = function(ent_code){
	if(RefreshFlag){
		getEsenceThreads(ent_code, tyhread_redis_salt, function(err){});
	}
};