'use strict';

var _ = require('lodash');
var loadUserLevel = require('./loadUserLevel');
var async=require('async');

exports.loadLevel=function(ent_code,items,callback){
    var openIds = [];
    _.forEach(items, function(d, i) {
        if(d.from && d.from.uid){
            openIds.push(d.from.uid);
        }
        if(d.to && d.to.uid){
            openIds.push(d.to.uid);
        }
        if(d.commentLevel1From && d.commentLevel1From.uid){
            openIds.push(d.commentLevel1From.uid);
        }
        if(d.commentLevel2From && d.commentLevel2From.uid){
            openIds.push(d.commentLevel2From.uid);
        }
        if(d.commentLevel2ThreadFrom && d.commentLevel2ThreadFrom.uid){
            openIds.push(d.commentLevel2ThreadFrom.uid);
        }
    });

    var tasks = [];
    _.forEach(openIds, function(open_id) {
        tasks.push(function(cont){
            loadUserLevel.loadLevelFromAPI(ent_code,open_id,cont);
        });
    });
    async.parallel(tasks,function(err,results){
        if (results && results.length>0) {//results: [{'egwegweg':1},{'gergergerg':3}]
            _.forEach(items, function(d, i) {
                if (items[i].toObject) {
                    items[i] = items[i].toObject();
                }
                _.forEach(results, function(r, j) {
                    if(r){
                        if(d.from && d.from.uid && r[d.from.uid]){
                            items[i].from.exp = r[d.from.uid];
                        }
                        if(d.to && d.to.uid && r[d.to.uid]){
                            items[i].to.exp = r[d.to.uid];
                        }
                        if(d.commentLevel1From && d.commentLevel1From.uid && r[d.commentLevel1From.uid]){
                            items[i].commentLevel1From.exp = r[d.commentLevel1From.uid];
                        }
                        if(d.commentLevel2From && d.commentLevel2From.uid && r[d.commentLevel2From.uid]){
                            items[i].commentLevel2From.exp = r[d.commentLevel2From.uid];
                        }
                        if(d.commentLevel2ThreadFrom && d.commentLevel2ThreadFrom.uid && r[d.commentLevel2ThreadFrom.uid]){
                            items[i].commentLevel2ThreadFrom.exp = r[d.commentLevel2ThreadFrom.uid];
                        }
                    }
                });

                if(d.from && !items[i].from.exp){
                    items[i].from.exp = 0;
                }
                if(d.to && !items[i].to.exp){
                    items[i].to.exp = 0;
                }
                if(d.commentLevel1From && !items[i].commentLevel1From.exp){
                    items[i].commentLevel1From.exp = 0;
                }
                if(d.commentLevel2From && !items[i].commentLevel2From.exp){
                    items[i].commentLevel2From.exp = 0;
                }
                if(d.commentLevel2ThreadFrom && !items[i].commentLevel2ThreadFrom.exp){
                    items[i].commentLevel2ThreadFrom.exp = 0;
                }
            });
        }
        return callback && callback();
    });
};

exports.loadLevelByUser=function(ent_code,items,callback){
    var openIds = [];
    _.forEach(items, function(d, i) {
        if(d.uid){
            openIds.push(d.uid);
        }
    });
    var tasks = [];
    _.forEach(openIds, function(open_id) {
        tasks.push(function(cont){
            loadUserLevel.loadLevelFromAPI(ent_code,open_id,cont);
        });
    });
    async.parallel(tasks,function(err,results){
        if (results && results.length>0) {//results: [{'egwegweg':1},{'gergergerg':3}]
            _.forEach(items, function(d, i) {
                if (items[i].toObject) {
                    items[i] = items[i].toObject();
                }
                _.forEach(results, function(r) {
                    if(r){
                        if(d.uid && r[d.uid]){
                            items[i].exp = r[d.uid];
                        }
                    }
                });

                if(!items[i].exp){
                    items[i].exp = 0;
                }
            });
        }
        return callback && callback();
    });
};