'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var forumSuggestionService=require('../../service/forumSuggestionService');
var forumUserService=require('../../service/forumUserService');
module.exports = function(app) {
    app.use('/admin/forum', router);
};


//获取
router.get('/suggestion/:id/get', function(req, res, next) {
    var id = req.params.id || null;
    if (id) {
        forumSuggestionService.getById(id, function(err,entity){
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {
                    data : entity
                };
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//屏蔽
router.post('/suggestion/:id/shield', function(req, res, next) {
    var id=req.params.id;
    if(id){
        forumSuggestionService.findOneAndUpdate({_id:id},{status: 2},function(err,entity){
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    }else{
        res.json(returnCode.WRONG_PARAM);
    }
});

//分页获取列表
router.get('/suggestion/searchList', function(req, res, next) {
    var pageNo = req.query.pageNo || 1,
        pageSize = req.query.pageSize || 10,
        title=req.query.title || '',
        content=req.query.content || '',
        mid=req.query.mid || '',
        nickName=req.query.nickName || '';

    var conditions={
        ent_code:req.session.user.ent_code,
        status:1
    };
    if(title){
        conditions.title={
            $regex: title,
            $options: 'i'
        };
    }
    if(content){
        conditions.content={
            $regex: content,
            $options: 'i'
        };
    }

    if(nickName || mid){
        //先找出用户
        var q = {};
        if(nickName){
            q.nickName = {
                $regex: nickName,
                $options: 'i'
            }
        }
        if(mid){
            q.mid = mid;
        }
        forumUserService.searchMembersWithFields(q, "_id", null, function(err, docs){
            if(err){
                console.error(err);
                res.json(returnCode.BUSY);
            }else{
                var ids = [];
                _.forEach(docs, function(e) {
                    ids.push(e._id);
                });
                conditions.from = {$in:ids}
                forumSuggestionService.getAll(conditions,pageNo,pageSize,function(err,results){
                    if(err){
                        console.error(err);
                        res.json(returnCode.BUSY);
                    }else{
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    }else{
        forumSuggestionService.getAll(conditions,pageNo,pageSize,function(err,results){
            if(err){
                console.error(err);
                res.json(returnCode.BUSY);
            }else{
                res.json(_.assign(results, returnCode.SUCCESS));
            }
        });
    }
});