'use strict';


var mongoose = require('mongoose'),
    Schema = mongoose.Schema;
//限制行为规则 
var ForumLimitActionSchema = new Schema({
    ent_code: {
        type: Number,
		require: true,
		index: true
    },
    title: {
        type: String,
		require: true
    },
    description: {
        type: String,
		require: false
    },
    status: { //0表示禁用，1表示启用
        type: Number,
		require: true,
		default: 1
    },
    limit_action_type: { //行为限制类型 ,字典看forumLimitActionConnfig表
        type: String,
		require: true,
		default: 0
    },
    limit_time: { //行为限制时间类型
        type: Number,
        require: true,
        default: 0
    },
    begin_time: {
        type: Date,
	    required: false   
    },
    end_time: {
        type: Date,
	    required: false   
    },
    created: {
        type: Date,
	    required: true,
	    default:Date.now    
    }
}, {
    'collection': 'pisns_forum_limit_action'
});


module.exports = mongoose.model('ForumLimitAction', ForumLimitActionSchema);
