'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题评论
var ForumCommentSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { //评论人
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	to: { //回复人
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	thread:{//文章
		type: Schema.Types.ObjectId,
		index: true,
		ref: 'ForumThread',
		require:true
	},
	level:{//评论等级 1、父评论 2、子评论
		type:String,
		require:true
	},
	comments:[{type: Schema.Types.ObjectId, ref: 'ForumComment'}], //评论的评论
	content: { //评论内容
		type: String,
		require: true
	},
	ip: { //IP地址
		type: String,
		require: true
	},
	comment_count: { //评论数量
		type: Number,
		require: true,
		default: 0
	},
	praise_count: { //点赞数量
		type: Number,
		require: true,
		default: 0
	},
	status: { //文章状态，1启用，0禁用，2需审核
		type: Number,
		require: true,
		default: 1
	},
	created: { //评论时间
		type: Date,
		require: true,
		default: Date.now
	},
	floor: { //评论楼层
		type: Number,
		require: false
	},
	oneCommentFloor:{ //一级评论楼层
		type: Number,
		require: false
	}
}, {
	'collection': 'pisns_forum_comment'
});


module.exports = mongoose.model('ForumComment', ForumCommentSchema);