'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//荣誉头衔
var ForumHonorTitleSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	title: { //荣誉头衔标题
		type: String,
		require: true,
	},
	icon: { //荣誉头衔图片
		type: String
	},
	order_idx: { //荣誉头衔排序
		type: Number,
		require: true,
		default: 0
	},
	status: { //荣誉头衔状态，1启用，0停用
		type: Number,
		require: true,
		default: 1
	},  
	is_show: { //显示荣誉头衔状态，1显示，0不显示
		type: Number,
		require: true,
		default: 1
	}, 
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}

}, {
	'collection': 'pisns_forum_honor_title'
});


module.exports = mongoose.model('ForumHonorTitle', ForumHonorTitleSchema);