'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//点赞日志
var ForumPraiseLogSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	user: { //点赞者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	type:{//点赞类型 1 文章 2 评论
		type: Number,
		require: true,
		default: 1
	},
	thread: { //点赞话题
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumThread'
	},
	comment: { //点赞评论
		type: Schema.Types.ObjectId,
		index: true,
		ref: 'ForumComment'
	},
	ip: { //IP地址
		type: String,
		require: true
	},
	status: { //状态，0点赞，1取消点赞
		type: Number,
		require: true,
		default: 0
	}, 
	created: { //点赞时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_praise_log'
});

module.exports = mongoose.model('ForumPraiseLog', ForumPraiseLogSchema);