'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题标签，标签分类
var ForumTagSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	title: { //标签标题
		type: String,
		require: true,
	},
	info:{	//板块
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumInfo'
	},
	type: { // 标签类型  1、前后台通用 2、后台使用
		type: Number,
		require: true,
		index: true,
		default: 1
	},
	icon: { //标签图片
		type: String
	},
	pv_count: { //访问量
		type: Number,
		require: true,
		default: 0
	},
	order_idx: { //标签排序
		type: Number,
		require: true,
		default: 0
	},
	status: { //标签状态，1启用，0禁用
		type: Number,
		require: true,
		default: 1
	},  
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}

}, {
	'collection': 'pisns_forum_tag'
});


module.exports = mongoose.model('ForumTag', ForumTagSchema);