'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题，文章
var ForumThreadAttendSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	thread:{//文章
		type: Schema.Types.ObjectId,
		index: true,
		ref: 'ForumThread',
		require:true
	},
	info: {
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumInfo'
	},
	from: { //发帖者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	attend: [{ //关注者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	}],
	total: { //关注数量
		type: Number,
		require: true,
		default: 0
	},
	created: {	//创建时间
	    type: Date,
	    required: true,
	    default:Date.now    
	},
	updated:{	//最后关注时间
		type: Date,
	    required: true,
	    default:Date.now    	
	}
}, {
	'collection': 'pisns_forum_thread_attend'
});


module.exports = mongoose.model('ForumThreadAttend', ForumThreadAttendSchema);