'use strict';
var mongoose = require('mongoose');
var ForumComplaint = mongoose.model('ForumComplaint');
var ForumThread = mongoose.model('ForumThread');
var ForumComment = mongoose.model('ForumComment');
var ForumUserService = require("./forumUserService");
var async=require('async');

exports.getForumComplaintPageList=function(condition,pageNo,pageSize,callback){
	var _condition = condition || {};
	var pageNo = Number(pageNo) || 1;
	var pageSize = pageSize || 10;
	var obj={};
		obj.total=0;
		obj.pageNo=pageNo;
		obj.pageSize=pageSize;
		obj.items=[];
	var search = function(count){
		var skip = (pageNo - 1) * pageSize;
		skip = skip >0 ? skip :0;
		var limit = pageSize;
		ForumComplaint.distinct('complaintId',_condition)
		.exec(function (err, complaints) {
			if(err){
				console.error(err);
				return callback && callback(err,null);
			}
			if(!complaints || complaints.length<=0){
				return callback && callback(null,obj);
	   	    }
	   	    obj.total=count;
			obj.pageNo=pageNo;
			obj.pageSize=pageSize;
	   	    var real_items= complaints.slice(skip,skip+limit);
	   	    var tasks = [];
	   	    var pushTask = function(i){
		   	    	var con={complaintId:real_items[i]};
		   	    	tasks.push(function(cb){
		   	    		ForumComplaint.find(con)
		   	    		.populate('complaintTo').exec(function(err,complaints){
		   	    			if(!err && complaints && complaints.length>0){
		   	    				var complaint=complaints[0];
		   	    				if(complaint && 
		   	    					'function' === typeof complaint.toObject){
		   	    					complaint = complaint.toObject();
		   	    				}
		   	    				complaint.sum=complaints.length;
		   	    				cb(null,complaint);
		   	    			}
		   	    		});
		   	    	});
		   	};
	   	    for(var i=0,len=real_items.length;i<len;i=i+1){
	   	    	pushTask(i);
	   	    }
	   	    async.parallel(tasks,function(err, results) {
	   	    	obj.items=results || [];
	   	    	return callback && callback(null,obj);
			});
		});
	};
	ForumComplaint.distinct('complaintId',_condition).exec(function (err, result) {
		if(err){
			return callback && callback(err,null);
		}
		if(!result || result.length<=0){
			return callback && callback(null,obj);
   	    }
		return search(result.length);
	});
};

exports.addComplaint = function(complaint,entcode,from,callback){
	if(!!!complaint || !!!complaint.complaintId || !!!complaint.type){
		return callback && callback('bad args');
	}
	complaint.ent_code = entcode;
	async.waterfall([function(cb) {
		var _Model = null;
		var type = 0;
		try{
			type =Number(complaint.type);
		}catch(e){}
		if(type === 1){
			_Model = ForumThread;
		}else if(type === 2){
			_Model = ForumComment;
		}
		if(!!!_Model){
			return callback && callback('bad args');
		}
		_Model.findById(complaint.complaintId).populate('from')
		.exec(function(err,result){
			if(err || !result){//没有对应的文章或评论
				return callback && callback(err || '无对应数据');
	    	}
	    	complaint.content = result.content;
	    	complaint.complaintTo = result.from;
	    	cb();
		});
	},function(cb) {
		if(!!!from){
			return cb();
		}
        ForumUserService.getUserById(from,
	    	function(err,result){
	    		if(!!!err && result){
	    			complaint.complaintFrom = result;
	    		}
	    		cb();
	    });
	},
	function(cb) {
		if(complaint.complaintFrom && complaint.complaintFrom._id){
			ForumComplaint.count({type:complaint.type,
			ent_code:entcode,
			complaintId:complaint.complaintId,
			complaintFrom:complaint.complaintFrom._id}).exec(function(err,count){
				if(err || count){
					return callback && callback('已经存在！');
				}
				cb();
			});
		}else{
			ForumComplaint.count({type:complaint.type,
			ent_code:entcode,
			complaintId:complaint.complaintId}).exec(function(err,count){
				if(err || count){
					return callback && callback('已经存在！');
				}
				cb();
			});
		}
	},
	function(n, cb) {
		var _complaint= new ForumComplaint(complaint);
		_complaint.save(function(err, result) {
			if(err){
				console.error(err);
				return callback && callback(err);
			}
			return callback && callback(null,result);
		});
	}],
	function(err, result) {
	     return callback && callback(err);
	});	
};

exports.removeComplaintById = function(id,callback){
	ForumComplaint.remove({ _id: id},function(err,result){
		if (err) {
			return callback && callback(err,null);
		} 
		return callback && callback(null,result);
	});
};

exports.getDetailByComplaintid = function(complaintid,callback){
	ForumComplaint.find({complaintId:complaintid})
	.populate('complaintTo').populate('complaintFrom')
	.exec(function(err,complaints){
		if (err) {
			return callback && callback(err,null);
		}
		return callback && callback(null,complaints);
 	});
};