'use strict';
var mongoose = require('mongoose');
var ForumLimitAction = mongoose.model('ForumLimitAction');

var async = require('async');
var then = require('thenjs');



//统计
function mapReduce(match, callback) {
    var o = {};
    var emit;
    o.query = match;
    o.map = function() {
        emit(this.limit_action_type, {
            id: this._id,
            title: this.title,
            description: this.description,
            ent_code: this.ent_code,
            limit_time: this.limit_time,
            limit_action_type: this.limit_action_type,
            status: this.status
        });
    };
    o.reduce = function(key, values) {
    	var array = [];
        var res = {
            datas: array
        };
        values.forEach(function(v) {
            res.datas.push(v);
        });
        return res;
    };
    ForumLimitAction.mapReduce(o, function(err, results) {
    	if (err){
			callback(err);
		}else{
			callback(null,results);
		}
    });
}

//创建论坛行为限制
exports.createLimitAction = function(entity, callback) {
    var forum = new ForumLimitAction(entity);
    forum.save(function(err, forum) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, forum);
        }
    });
};

//根据ID获取论坛角色
exports.getLimitActionById = function(rid, callback) {
    ForumLimitAction.findById(rid, function(err, role) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, role);
        }
    });
};

//根据ID更新论坛角色
exports.updateLimitActionById = function(rid, entity, callback) {
    ForumLimitAction.update({
        _id: rid
    }, entity, null, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//根据ID更新论坛角色
exports.deleteLimitActionById = function(rid, callback) {
    ForumLimitAction.remove({
        _id: rid
    }, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//获取数量
function countAll(conditions, callback) {
    ForumLimitAction.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}

//分页获取全部列表数据
exports.getAllLimitAction = function(conditions, pageNo, pageSize, callback) {
    countAll(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);
            ForumLimitAction.find(conditions).skip(skip).limit(limit).sort('created').exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err, null);
                } else {
                    var obj = {};
                    obj.total = count;
                    obj.pageNo = pageNo;
                    obj.pageSize = pageSize;
                    obj.items = docs;
                    callback(null, obj);
                }
            });
        }
    });
};

//获取全部列表数据
exports.getAllLimitActionNotPage = function(conditions,callback) {
    ForumLimitAction.find(conditions).exec(function(err, docs) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, docs);
        }
    });
};

//分组获取全部列表数据
exports.getAllLimitActionGroupByType = function(conditions, callback) {
    mapReduce(conditions, function(err, datas) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, datas);
        }
    });
};
