'use strict';
var mongoose = require('mongoose');
var forumLimitOperationLog = mongoose.model('ForumLimitOperationLog');

var async = require('async');
var then = require('thenjs');
var moment = require('moment');


//获取数量
function countAll(conditions, callback) {
    forumLimitOperationLog.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}


//创建行为限制log
exports.createOperationLog = function(entity, callback) {
    var forum = new forumLimitOperationLog(entity);
    forum.save(function(err, forum) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, forum);
        }
    });
};


//获取全部列表数据
exports.getAllLimitOperationLog= function(conditions,callback) {
	forumLimitOperationLog.find(conditions).exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs);
		}
	});
};


//分页获取全部列表数据
exports.getAllLimitAction = function(conditions, pageNo, pageSize, callback) {
    countAll(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);
            forumLimitOperationLog.find(conditions).skip(skip).limit(limit).sort('-created').exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err, null);
                } else {
                    var obj = {};
                    obj.total = count;
                    obj.pageNo = pageNo;
                    obj.pageSize = pageSize;
                    obj.data = docs;
                    callback(null, obj);
                }
            });
        }
    });
};