'use strict';
var mongoose = require('mongoose');
var forumLimitOperation = mongoose.model('ForumLimitOperation');

var async = require('async');
var then = require('thenjs');
var moment = require('moment');

//格式化日期 (格式：年-月-日)
function date_format(date) {
    return moment(date).format('YYYY-MM-DD');
}


//判断时间是否在指定范围
function compareTime(now, begin_time, end_time) { // 禁言中 true
    now = date_format(now);
    begin_time = date_format(begin_time);
    end_time = date_format(end_time);
    if (moment(now).isSame(begin_time) || moment(now).isSame(end_time)) { //如果等于开始时间或者结束时间
        return true;
    } else {
        return moment(now).isBetween(begin_time, end_time);
    }
}


//获取单个行为限制
function getLimitOperation(userId,callback){
	forumLimitOperation.findOne({userId:
		userId}, function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
}

//创建或更新论坛行为限制
exports.createOrUpdateLimitOperation=function(conditions,entity,callback){
	forumLimitOperation.findOneAndUpdate(conditions, {
        limit_actions: entity.limit_actions
    }, function(err, doc) {
        if (err) {
        	console.log(err);
            callback(err, null);
        } else {
            if(!doc){
            	var forum = new forumLimitOperation(entity);
				forum.save(function(err, forum) {
					if (err) {
						console.error(err);
						callback(err,null);
					} else {
						callback(null,forum);
					}
				});
            }else{
            	callback(null,doc);
            }
        }
    });
};


//根据userId获取
exports.getLimitOperationByUserId=function(userId,callback){
	getLimitOperation(userId, function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			//判断是否在用,过期的赋为空
			if(doc){
        		var limit_actions = doc.limit_actions;
                for (var i = limit_actions.length  - 1; i >= 0 ; i -= 1) {
                    var limit_action = limit_actions[i];
                    if(limit_action.begin_time && limit_action.end_time){
                		var begin_time = new Date(limit_action.begin_time).getTime(),
                			ent_time = new Date(limit_action.end_time).getTime(),
                			now = new Date().getTime();
                		if(now > ent_time){
                			limit_actions.splice(i,1);
                		}
                	}
                }
        	}
			callback(null,doc);
		}
	});
};


//检查用户是否被禁言
exports.checkLimitOperationProhibitionOfSpeech = function(userId,callback) {
	if(userId){
		var isProhibition = false;
		getLimitOperation(userId,function(err,forumLimitOperation){
			if (err) {
				console.error(err);
				callback(err, null);
			} else {
				// 获取到用户行为限制记录
				if(forumLimitOperation){
					var limit_actions = forumLimitOperation.limit_actions;
	                for (var i = 0; i < limit_actions.length; i += 1) {
	                    var limit_action = limit_actions[i];
	                    if(limit_action.limit_type === 1){
	                    	if(limit_action.begin_time && limit_action.end_time){
	                    		var begin_time = new Date(limit_action.begin_time).getTime(),
	                    			ent_time = new Date(limit_action.end_time).getTime(),
	                    			now = new Date().getTime();
	                    		if(now >= begin_time && now <=ent_time){
	                    			isProhibition = true;
	                    			break;
	                    		}
	                    	}
	                    }
	                }
	                callback(null, isProhibition);
				}else{
					callback(null, isProhibition);
				}
			}
		});
	}else{
		callback(null, isProhibition);
	}
};


//检查用户是否被禁加积分
exports.checkLimitOperationProhibitionAddIntegral = function(userId,callback) {
	var isProhibition = false;
	if(userId){
		getLimitOperation(userId,function(err,forumLimitOperation){
			if (err) {
				console.error(err);
				callback(err, null);
			} else {
				// 获取到用户行为限制记录
				if(forumLimitOperation){
					var limit_actions = forumLimitOperation.limit_actions;
	                for (var i = 0; i < limit_actions.length; i += 1) {
	                    var limit_action = limit_actions[i];
	                    if(limit_action.limit_type === 2){
	                    	if(limit_action.begin_time && limit_action.end_time){
	                    		var begin_time = new Date(limit_action.begin_time).getTime(),
	                    			ent_time = new Date(limit_action.end_time).getTime(),
	                    			now = new Date().getTime();
	                    		if(now >= begin_time && now <=ent_time){
	                    			isProhibition = true;
	                    			break;
	                    		}
	                    	}
	                    }
	                }
	                callback(null, isProhibition);
				}else{
					callback(null, isProhibition);
				}
			}
		});
	}else{
		callback(null, isProhibition);
	}
};