'use strict';
var mongoose = require('mongoose');
var ForumShareConfig = mongoose.model('ForumShareConfig');

var then = require('thenjs');

//批量创建配置信息
exports.create = function(entity, callback) {
    var forumShareConfig = new ForumShareConfig(entity);

    then(function(cont) {
        ForumShareConfig.find({
            ent_code: entity.ent_code,
            meta_key: entity.meta_key
        }).exec(cont);
    }).then(function(cont, config) {
        if (config.length > 0) {
            //更新
            ForumShareConfig.update({
                    meta_key: entity.meta_key,
                    ent_code: entity.ent_code
                }, {
                    meta_value: entity.meta_value
                }, {
                    multi: false
                },
                function(affected,result) {
                    cont(null,result);
                });
        } else {
            //增加
            forumShareConfig.save(function(err, result) {
                if (err) {
                   cont(err);
                } else {
                    cont(null,result);
                }
            });
        }
    }).then(function(cont,result) {
        callback(null, result);
    }).fail(function(cont, err) {
        console.error(err);
        callback(err, null);
    });


};

exports.getByKey = function(ent_code, key, callback) {
    ForumShareConfig.findOne({
        ent_code: ent_code,
        meta_key: key
    }, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, result);
        }
    });
}

//根据ent_code获取配置信息
exports.getByEntCode = function(ent_code, callback) {
    ForumShareConfig.find({
        ent_code: ent_code
    }, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, result);
        }
    });
};

//根据
