'use strict';

var redis=global.redis;
var prefix = '_forum_comment_count_';
var expire = 60*60*24*180;
function getKey(entcode,userId){
	return entcode + prefix + userId;
}

exports.clear = function(entcode,userId,callback){
	var key = getKey(entcode,userId);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.del(key, function(error, res){
		return callback && callback(error, !!res);
    });
};

exports.incrTips=function(entcode,userId,callback){
	var key = getKey(entcode,userId);
	console.log('增加'+key);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.incr(key, function(error, res){
		redis.expire(key, expire);
		return callback && callback(error, !!res);
    });
	
};

exports.get=function(entcode,userId,callback){
	var key = getKey(entcode,userId);
	console.log('获取'+key);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.get(key, function(error, res){
		return callback && callback(error, res || 0);
    });
};