'use strict';

var redis=global.redis;
var prefix = '_userPraiseLog_';
var expire = 60*60*12;


var _ = require('lodash');
var then = require('thenjs');
var forumPraiseLogService=require('../service/forumPraiseLogService');

function getKey(entcode,userId,type){
	var key = entcode + userId + prefix + type;
	return key;
}

function setToRedis(entcode,userId,type,value){
	var key = getKey(entcode,userId,type);
	if(!redis){
		console.log('redis error');
		return 'error'
	}
	redis.set(key, value, function(error, res){
		redis.expire(key, expire);
		return 'success'
	});
}

exports.get=function(entcode,userId,type,callback){
	var key = getKey(entcode,userId,type);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.get(key, function(error, res){
		if(!res){
			//不存在，先获取再返回
			getPraiseLogs(entcode, userId, function(err){
				redis.get(key, function(error, res){
					return callback && callback(error, res.split(",") || 0);
			    });
			});
		}else{
			return callback && callback(error, res.split(",") || 0);
		}
    });
};

exports.set=function(entcode,userId,type,value,callback){
	var key = getKey(entcode,userId,type);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.set(key, value, function(error, res){
		redis.expire(key, expire);
		return callback && callback(error, 'success');
	});
};


exports.clear = function(entcode,userId,type,callback){
	var key = getKey(entcode,userId,type);
	if(!redis){
		console.log('redis error');
		return callback && callback('error');
	}
	redis.del(key, function(error, res){
		return callback && callback(error, !!res);
    });
};


function getPraiseLogs(ent_code,userId,callback){
	if(userId && ent_code){
		var conditions = {
			user:userId,
			ent_code:ent_code,
			status:{$ne : 1}
		}

		then.parallel([
	        function(cont) { //查询帖子点赞
	        	conditions.type = 1;
	            forumPraiseLogService.queryPraiseLogV3(conditions, function(err, docs){
	            	var threads = [];
	            	_.forEach(docs, function(e) {
                        threads.push(e.thread);
                    });
		            cont(err, threads);
		        });
	        },
	        function(cont) { //查询评论点赞
	        	conditions.type = 2;
	            forumPraiseLogService.queryPraiseLogV3(conditions, function(err, docs){
	            	var comments = [];
	            	_.forEach(docs, function(d) {
	            		comments.push(d.comment);
	            	});
		            cont(err, comments);
		        });
	        }
	    ]).then(function(cont, results) {
	    	setToRedis(ent_code,userId,'thread',results[0]);
	    	setToRedis(ent_code,userId,'comment',results[1]);
	        callback(null);
	    }).fail(function(cont, err) {
	        console.error(err);
	        callback(err);
	    });
	}else{
		callback('err');
	}
}