'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var mongoose = require('mongoose');
var forumFavoriteService=require('../../service/forumFavoriteService');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//文章收藏
router.post('/favorite/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumFavoriteService.createFavorite(req.body,function(err,entity){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':entity._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//删除收藏
router.post('/favorite/:fid/delete', function(req, res, next) {
	var fid=req.params.fid;
	if(fid){
		forumFavoriteService.deleteFavoriteById(fid,function(err,thread){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取当前用户的收藏列表
router.get('/favorite/list', function(req, res, next) {
	var user=req.query.user;
	if(fid){
		forumThreadService.getAll(req.session.user.ent_code,user,pageNo,pageSize,function(err,results){
			if(err){
				console.error(err);
				res.json(returnCode.BUSY);
			}else{
				res.json(_.assign(results, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

