'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var ForumBlackListService=require('../../service/forumBlackListService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//增加黑名单
router.post('/blacklist', function(req, res, next) {
	var ent_code=req.session.user.ent_code;
	ForumBlackListService.addBlack(req.body,ent_code,function(err,result){
		if(err){
			res.json(returnCode.UNCHECK_ERROR(err));
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//导入黑名单excel
router.post('/importExcelBlacklist', function(req, res, next) {
	var blacks = req.body.blacks;
	var ent_code=req.session.user.ent_code;
	ForumBlackListService.addBlacks(blacks,ent_code,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//获取黑名单分页列表
router.get('/blacklist', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var status=req.query.status;
    var blackOpenId = req.query.blackOpenId;
    var conditions={
    	ent_code:req.session.user.ent_code
    };
    if(status){
    	conditions.status = status;
    }
    if(blackOpenId){
    	conditions.blackOpenId = {
            $regex: blackOpenId,
            $options: 'i'
        };
    }
	ForumBlackListService.getBlackPageList(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

//获取黑名单根据id
router.get('/blacklist/:id', function(req, res, next) {
	var id = req.params.id;
	ForumBlackListService.getBlackById(id,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//删除黑名单根据id
router.get('/blacklist/:id/del', function(req, res, next) {
	var id = req.params.id;
	ForumBlackListService.removeBlackById(id,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//更新
router.post('/blacklist/:id', function(req, res, next) {
	var id = req.params.id;
	ForumBlackListService.updateBlackById(id,req.body,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

router.get('/userList', function(req, res, next) {
	var obj={total:0};
		obj.items=[];
	var ent_code=req.session.user.ent_code;
	ForumBlackListService.getNotBlackUsers(ent_code,req.query.pageNo,req.query.pageSize,
	function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			obj.items = result.items;
			obj.total = result.total;
			res.json(_.assign(obj, returnCode.SUCCESS));
		}
	});
});