'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');

var forumLimitActionService=require('../../service/forumLimitActionService');
var forumLimitActionConfigService=require('../../service/forumLimitActionConfigService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增论坛行为限制
router.post('/limitAction/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumLimitActionService.createLimitAction(req.body,function(err,forum){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = forum;
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//获取论坛行为限制
router.get('/limitAction/:rid/get', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumLimitActionService.getLimitActionById(rid,function(err,forumLimitAction){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				var rs = {};
				rs.data=forumLimitAction;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//删除论坛行为限制
router.post('/limitAction/:rid/delete', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumLimitActionService.deleteLimitActionById(rid,function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//更新论坛行为限制
router.post('/limitAction/:rid/update', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumLimitActionService.updateLimitActionById(rid,req.body,function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取行为限制列表
router.get('/limitAction/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var limitActionName=req.query.limitActionName;

    var conditions={
    	ent_code:req.session.user.ent_code
    };
    if(limitActionName){
    	conditions.title={
    		$regex: limitActionName,
			$options: 'i'
    	};
    }
    forumLimitActionService.getAllLimitAction(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});


//获取行为限制列表
router.get('/limitAction/list/groupByType', function(req, res, next) {
    var conditions={
    	ent_code:req.session.user.ent_code,
    	status:1
    };
    forumLimitActionService.getAllLimitActionGroupByType(conditions,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			forumLimitActionConfigService.getAllLimitActionConfig(function(err,configs){
				if(err){
					console.error(err);
					res.json(returnCode.BUSY);
				}else{
					var array = [];
					for(var i in results){
						var limitAction = results[i];
						var newObject = {
							cid:limitAction._id,
							name:""
						};
						for(var j in configs){
							var config = configs[j];
							if(limitAction._id ===  config.code){
								newObject.name = config.name;
								break;
							}
						}
						newObject.datas = [];
						if(limitAction.value.datas){
							newObject.datas = limitAction.value.datas;
						}else{
							newObject.datas.push(limitAction.value);
						}
						array.push(newObject);
					}
					var obj = {
						items:array
					}
					res.json(_.assign(obj, returnCode.SUCCESS));
				}
			});
		}
	});
});