'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');

var forumLimitActionConfigService=require('../../service/forumLimitActionConfigService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};



//获取论坛行为限制
router.get('/limitActionConfig/:rid/get', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumLimitActionConfigService.getLimitActionConfigById(rid,function(err,forumLimitActionConfig){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				var rs = {};
				rs.data=forumLimitActionConfig;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取行为限制列表
router.get('/limitActionConfig/list', function(req, res, next) {
    forumLimitActionConfigService.getAllLimitActionConfig(function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			var obj = {
				item:results
			}
			res.json(_.assign(obj, returnCode.SUCCESS));
		}
	});
});
