'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var moment = require('moment');

var forumLimitActionService = require('../../service/forumLimitActionService');
var forumLimitActionRefService = require('../../service/forumLimitActionRefService');

module.exports = function(app) {
    app.use('/admin/forum', router);
};

//新增或更新论坛行为限制
router.post('/limitActionRef/createOrUpdate', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var userId = req.body.userId;
    var selects = req.body.selects;

    var limit_actions = [];

    var conditions = {
        ent_code: ent_code,
        status: 1
    };
    forumLimitActionService.getAllLimitActionNotPage(conditions, function(err, results) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        }
        if(selects && results){
            for (var i = 0; i < selects.length; i+=1) {
                for(var j = 0; j < results.length; j+=1){
                    if (selects[i] === results[j]._id.toString()) {
                        var begin_time = moment(new Date()).format('YYYY-MM-DD');
                        var end_time = moment(new Date()).add(results[j].limit_time, 'days').format('YYYY-MM-DD');
                        var obj = {
                            limit_action: selects[i],
                            limit_action_type: results[j].limit_action_type,
                            begin_time: new Date(begin_time),
                            end_time: new Date(end_time)
                        }
                        limit_actions.push(obj);
                        break;
                    }
                }
            }
        }
        var forumLimitActionRef = {
            ent_code: ent_code,
            userId: userId,
            limit_actions: limit_actions
        }

        forumLimitActionRefService.createOrUpdateLimitActionRef({
            userId: userId,
            ent_code: ent_code,
            status: 1
        }, forumLimitActionRef, function(err, forum) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {
                    data: forum
                }
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    })
});

//根据userId获取论坛行为限制
router.get('/limitActionRef/:userId/get', function(req, res, next) {
    var userId = req.params.userId;
    if (userId) {
        forumLimitActionRefService.getLimitActionRefByMid(userId, function(err, forumLimitActionRef) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {};
                rs.data = forumLimitActionRef;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});



//获取行为限制列表
// router.get('/limitActionRef/list', function(req, res, next) {
//     var pageNo = req.query.pageNo || 1;
//     var pageSize = req.query.pageSize || 10;
//     var limitActionName = req.query.limitActionName;

//     var conditions = {
//         ent_code: req.session.user.ent_code
//     };
//     if (limitActionName) {
//         conditions.title = {
//             $regex: limitActionName,
//             $options: 'i'
//         };
//     }
//     forumLimitActionRefService.getAllLimitActionRef(conditions, pageNo, pageSize, function(err, results) {
//         if (err) {
//             console.error(err);
//             res.json(returnCode.BUSY);
//         } else {
//             res.json(_.assign(results, returnCode.SUCCESS));
//         }
//     });
// });
