'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash'),
    thenjs = require('thenjs');
var mongoose = require('mongoose');
var Notice = mongoose.model('ForumNotice');

module.exports = function(app) {
    app.use('/admin/forum', router);
};

function getPageInfo(pageNo,pageSize,count){
	var skip,limit;
	pageNo=pageNo || 1;
	pageSize=pageSize || 10;
	skip = (pageNo - 1) * pageSize;
	limit = count - skip > pageSize ? pageSize : (count - skip);
	if (skip > count / 2 && pageNo > 10000) {
		skip = limit > pageSize ? (count - skip - pageSize) : 0;
	}
	if(skip < 0){
		skip = 0;
	}
	return {
		pageNo:pageNo,
		pageSize:pageSize,
		skip:skip,
		limit:limit
	};
}

function queryList(condition,sort,pageNo,pageSize,callback){
	condition= condition || {};
	sort= sort || {};
	thenjs(function(cont){
		Notice.find(condition).count(function(err,count){
			if(err){
				return cont && cont(err);
			}
			if(!!!count){
				return callback && callback(false,{data:[],total:0});
			}
			cont(null,count,getPageInfo(pageNo,pageSize,count));
		});
	})
	.then(function(cont,count,pageInfo){
		Notice.find(condition).populate('plate').sort(sort).limit(pageInfo.limit).skip(pageInfo.skip).exec(function(err,results){//分页查询
			if(err){
				return callback && callback({err:err});
			}
			return callback && callback(false,{data:results,total:count});
		});
	})
	.fail(function(cont,err){
		console.log(err);
		return callback && callback({err:err});
	});
}

function update(obj,callback){
	if(!!!obj || !!!obj.id){
		return callback && callback({err:'参数错误！'});
	}
	var id=obj._id;
	Notice.findByIdAndUpdate(id,obj,function(err,notice){
		if(err){
			return callback && callback(err);
		}
		return callback && callback({result:true});
	});
}

router.post('/notice', function(req, res, next) {
	req.body.ent_code = req.session.user.ent_code;
	var notice = new Notice(req.body);
	notice.save(function(err){
		if(err){
			return res.json({err:err});
		}
		res.json({result:true});
	});
});

router.post('/notice/update', function(req, res, next) {
	update(req.body,function(err,result){
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});


router.post('/notice/search', function(req, res, next) {
	var pageNo=req.body.pageNo,
        pageSize=req.body.pageSize,
        type=req.body.type,
        title=req.body.title,
        label=req.body.label,
		plate=req.body.plate,
		//createtime=req.body.createtime;
        sort=req.body.sort,

        begin_time=req.body.begin_time,
        end_time=req.body.end_time,
        top=req.body.top,
        status=req.body.status,
        finished=req.body.finished;
    var _condition = {ent_code:req.session.user.ent_code},_sort = {};
    //如果sort为空
    if(!sort)
    {
    	_sort = {top:-1,createtime:-1};
    }
 	if(sort){
 		 _sort[sort] = -1;//降序
 		// console.log("改了排序");
 		//_sort = {top:-1,createtime:-1};
 	}

 	if(title){
 		_condition.title = new RegExp(title, 'i');
 	}

 	if(label){
 		_condition.label = new RegExp(label, 'i');
 	}
 	
    if(begin_time){
    	if(!!!_condition.createtime){
    		_condition.createtime={};
    	}
    	var gte='$gte';
    	_condition.createtime[gte]=begin_time;
    }   
    if(end_time){
    	if(!!!_condition.createtime){
    		_condition.createtime={};
    	}
    	var lte='$lte';
    	_condition.createtime[lte]=end_time;
    }

    try{
    	if(!!type){
    		_condition.type = Number(type);
    	}
 	}catch(err){
 		delete _condition.type;
 	}
    try{
    	if(!!top){
    		_condition.top = Number(top);
    	}
 	}catch(err){
 		delete _condition.top;
 	}	
 	try{
 		if(!!status){
    		_condition.status = Number(status);
    	}
 	}catch(err){
 		delete _condition.status;
 	}

 	try{
 		if(!!finished){
    		_condition.finished = Number(finished);
    	}
 	}catch(err){
 		delete _condition.finished;
 	}
	
	if(!!plate){
    		_condition.plate = plate;
    }
	
	queryList(_condition,_sort,pageNo,pageSize,function(err,result){
		console.log(err);
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});

router.get('/notice/:id', function(req, res, next) {
	Notice.findById(req.params.id,function(err,result){
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});