'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');
var ForumRolePermission = mongoose.model('ForumRolePermission');
var forumRolePermissionService=require('../../service/forumRolePermissionService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增角色权限
router.post('/rolePermiss/create', function(req, res, next) {
	var rs = {};
	var form = {
		ent_code: req.session.user.ent_code
	};

	req.body=buildField(req.body);

	var group = new ForumRolePermission(_.assign(form, req.body));
	group.save(function(err, group) {
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':group._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//获取角色权限
router.get('/rolePermiss/:pid/get', function(req, res, next) {
	var rs = {};
	var pid=req.params.pid;
	if(pid){
		ForumRolePermission.findById(pid,function(err,permiss){
			if(err){
				console.log(err);
				res.json(returnCode.BUSY);
			}else{
				var json={};
				json._id=permiss._id;
				json.role=permiss.role;
				json.permission=permiss.permission;

				var rules=permiss.rules;
				var integral='',exp='';
				for(var i=0;i<rules.length;i=i+1){
					if(rules[i].key=='integral'){//积分
						integral=rules[i].value;
					}else if(rules[i].key=='exp'){//经验
						exp=rules[i].value;
					}
				}
				var data={};

				if(integral!=='' && integral.indexOf('-')!==-1){
					var integArray=integral.split('-');
					json.l_integral=integArray[0]===''?'':Number(integArray[0]);
					json.r_integral=integArray[1]===''?'':Number(integArray[1]);
				}
				if(exp!=='' && exp.indexOf('-')!=-1){
					var expArray=exp.split('-');
					json.l_exp=expArray[0]===''?'':Number(expArray[0]);
					json.r_exp=expArray[1]===''?'':Number(expArray[1]);
				}

				rs.data = json;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//删除论坛权限
router.post('/rolePermiss/:pid/delete', function(req, res, next) {
	var pid=req.params.pid;
	if(pid){
		ForumRolePermission.remove({ _id: pid},function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//构造规则、操作权限字段
function buildField(entity){
	//-------------------------设置匹配规则开始
	var rules=[];

	var l_integral=entity.l_integral || '';
	var r_integral=entity.r_integral || '';
	var integral_value=l_integral;
	integral_value=integral_value+'-'+r_integral;

	var l_exp=entity.l_exp || '';
	var r_exp=entity.r_exp || '';
	var exp_value=l_exp;
	exp_value=exp_value+'-'+r_exp;

	var integralRule={
		'key':'integral',
		'value':integral_value
	};
	
	var expRule={
		'key':'exp',
		'value':exp_value
	};

	rules.push(integralRule);
	rules.push(expRule);
	entity.rules=rules;
	//-----------------------------设置匹配规则结束

	//-----------------------------设置操作权限开始
	var permissions=entity.permission;
	for(var i=0;i<permissions.length;i=i+1){
		var obj=permissions[i];
		if(obj.checked){
			obj.value="1";
		}else{
			obj.value="0";
		}
		permissions[i]=obj;
	}
	console.log(permissions);
	entity.permission=permissions;
	//-----------------------------设置操作权限结束
	
	return entity;
}

//更新论坛角色
router.post('/rolePermiss/:pid/update', function(req, res, next) {
	var pid=req.params.pid;
	if(pid){
		req.body=buildField(req.body);
		
		ForumRolePermission.update({ _id: pid}, req.body,null,function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取角色权限列表
router.get('/rolePermiss/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

	forumRolePermissionService.getAllRolePermission(req.session.user.ent_code,pageNo,pageSize,function(err,docs){
    	if(err){
    		res.json(returnCode.BUSY);
    	}else{
			res.json(_.assign(docs, returnCode.SUCCESS));
    	}
    });
});

