'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');
var ForumTag = mongoose.model('ForumTag');

var forumTagService=require('../../service/forumTagService');
var forumThreadService=require('../../service/forumThreadService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增论坛标签
router.post('/tag/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumTagService.createTag(req.body,function(err,entity){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':entity._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//标签置顶
router.get('/tag/:tid/top',function(req,res,next){
	var tid = req.params.tid;
	var tag_top = req.query.tag_top;
	forumThreadService.updateTagTop(tid,tag_top,function(err,result){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//删除论坛标签
router.post('/tag/:tid/delete', function(req, res, next) {
	var tid=req.params.tid;
	if(tid){
		forumTagService.deleteTagById(tid,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//更新论坛标签
router.post('/tag/:tid/update', function(req, res, next) {
	var tid=req.params.tid;
	if(tid){
		forumTagService.updateTagById(tid,req.body,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取论坛标签
router.get('/tag/:tid/get', function(req, res, next) {
	var tid = req.params.tid || null;
	var rs = {};
	if (tid) {
		forumTagService.getTagById(tid,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = entity;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

//查询所有标签
router.get('/tag/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1,
    	pageSize = req.query.pageSize || 10,
    	tagName=req.query.tagName || '',
    	info = req.query.info || '';

    var conditions={
    	ent_code:req.session.user.ent_code
    };
    if(tagName){
    	conditions.title={
    		$regex: tagName,
			$options: 'i'
    	};
    }
    if(info){
    	conditions.info = info;
    }
	forumTagService.getAllTag(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

