'use strict';
var express = require('express'),
	router = express.Router(),
	user = require('../../utils/user'),
	returnCode = require('../../utils/returnCode'),
	commentTips = require('../../utils/commentTips'),
	_ = require('lodash');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

router.get('/commentTips', function(req, res, next) {
	var userId = user.getMobileUser(req);
	var entcode = req.session.user.ent_code;
	commentTips.get(entcode,userId,function(err,result){
		if(err){
			res.json(returnCode.UNCHECK_ERROR(err));
		}else{
			res.json(_.assign({data:result}, returnCode.SUCCESS));
		}
	});
});

router.put('/commentTips/:id', function(req, res, next) {
	var userId = req.params.id;
	var entcode = req.session.user.ent_code;
	commentTips.incrTips(entcode,userId,function(err,result){
		if(err){
			res.json(returnCode.UNCHECK_ERROR(err));
		}else{
			res.json(_.assign({data:result}, returnCode.SUCCESS));
		}
	});
});

router.post('/commentTips/del', function(req, res, next) {
	var userId = user.getMobileUser(req);
	var entcode = req.session.user.ent_code;
	commentTips.clear(entcode,userId,function(err,result){
		if(err){
			res.json(returnCode.UNCHECK_ERROR(err));
		}else{
			res.json(_.assign({data:result}, returnCode.SUCCESS));
		}
	});
});