'use strict';
var express = require('express'),
    router = express.Router(),
    user = require('../../utils/user'),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var forumAboutMEService=require('../../service/forumAboutMEService');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

router.get('/aboutme/me2other', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var entcode = req.session.user.ent_code;
    var pageNo=req.query.pageNo || 1;
    var pageSize=req.query.pageSize || 10;
    console.log(userId);
    console.log(entcode);
    forumAboutMEService.me2other(entcode,userId,pageNo,pageSize,function(err,result){
        if(err){
            res.json(returnCode.UNCHECK_ERROR(err));
        }else{
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});

router.get('/aboutme/other2me', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var entcode = req.session.user.ent_code;
    var pageNo=req.query.pageNo || 1;
    var pageSize=req.query.pageSize || 10;
    console.log(userId);
    console.log(entcode);
    forumAboutMEService.other2me(entcode,userId,pageNo,pageSize,function(err,result){
        if(err){
            res.json(returnCode.UNCHECK_ERROR(err));
        }else{
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});

router.get('/aboutme/he2other/:id/:entcode', function(req, res, next) {
    var userId = req.params.id;
    var entcode = req.params.entcode;
    var pageNo=req.query.pageNo || 1;
    var pageSize=req.query.pageSize || 10;
    forumAboutMEService.me2other(entcode,userId,pageNo,pageSize,function(err,result){
        if(err){
            res.json(returnCode.UNCHECK_ERROR(err));
        }else{
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});

router.get('/aboutme/other2he/:id/:entcode', function(req, res, next) {
    var userId = req.params.id;
    var entcode = req.params.entcode;
    var pageNo=req.query.pageNo || 1;
    var pageSize=req.query.pageSize || 10;
    forumAboutMEService.other2me(entcode,userId,pageNo,pageSize,function(err,result){
        if(err){
            res.json(returnCode.UNCHECK_ERROR(err));
        }else{
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});