'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash'),
    thenjs = require('thenjs');
var mongoose = require('mongoose');
var Notice = mongoose.model('ForumNotice');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

function getPageInfo(pageNo,pageSize,count){
	var skip,limit;
	pageNo=pageNo || 1;
	pageSize=pageSize || 10;
	skip = (pageNo - 1) * pageSize;
	limit = count - skip > pageSize ? pageSize : (count - skip);
	if (skip > count / 2 && pageNo > 10000) {
		skip = limit > pageSize ? (count - skip - pageSize) : 0;
	}
	if(skip < 0){
		skip = 0;
	}
	return {
		pageNo:pageNo,
		pageSize:pageSize,
		skip:skip,
		limit:limit
	};
}

function queryList(condition,sort,pageNo,pageSize,callback){
	condition= condition || {};
	sort= sort || {};
	thenjs(function(cont){
		Notice.find(condition).count(function(err,count){
			if(err){
				return cont && cont(err);
			}
			if(!!!count){
				return callback && callback(false,{data:[],total:0});
			}
			cont(null,count,getPageInfo(pageNo,pageSize,count));
		});
	})
	.then(function(cont,count,pageInfo){
		Notice.find(condition).sort(sort).limit(pageInfo.limit).skip(pageInfo.skip).exec(function(err,results){//分页查询
			if(err){
				return callback && callback({err:err});
			}
			return callback && callback(false,{data:results,total:count});
		});
	})
	.fail(function(cont,err){
		console.log(err);
		return callback && callback({err:err});
	});
}

/*
status = 1
and 
finished = 0 
and 
startdate 小于等于当前时间
and
indate大于等于当前时间
然后按top降序   startdate 降序
*/
// exports.newestMsg = function(req,res) {
// 	var pageNo=req.query.pageNo,
//         pageSize=req.query.pageSize;

// 	var curdate = new Date(),
// 	_condition = {status:1,finished:0,
// 					startdate:{$lte:curdate},
// 					indate:{$gte:curdate},
// 				},_sort = {top:-1,startdate:-1};
// 	queryList(_condition,_sort,pageNo,pageSize,function(err,result){
// 		console.log(err);
// 		if(err){
// 			return res.json(err);
// 		}
// 		return res.json(result);
// 	});
// };
/*20150422修改消息的规则
	根据type  =2  为消息
*/
router.get('/notice/newestMsg', function(req, res, next) {
	var pageNo=req.query.pageNo,
        pageSize=req.query.pageSize,
		plate=req.query.plate;
		
	var _condition = {status:1,type:2,ent_code:req.session.user.ent_code},_sort = {top:-1,createtime:-1};
	if(plate){
		_condition.$or=[{plate:plate},{plate:null}];
	}else{
		_condition.plate=null;
	}
	queryList(_condition,_sort,pageNo,pageSize,function(err,result){
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});

/*
status = 1
and 
finished = 0 
and 
startdate 小于等于当前时间
and
indate大于等于当前时间
然后按top降序   startdate 降序
*/
router.get('/notice/newestAct', function(req, res, next) {
	var pageNo=req.query.pageNo,
        pageSize=req.query.pageSize,
		plate=req.query.plate;

	var curdate = new Date(),
	_condition = {status:1,finished:0,type:1,
					ent_code:req.session.user.ent_code,
					startdate:{$lte:curdate},
					indate:{$gte:curdate},
				},_sort = {top:-1,createtime:-1};
	if(plate){
		_condition.$or=[{plate:plate},{plate:null}];
	}else{
		_condition.plate=null;
	}
	queryList(_condition,_sort,pageNo,pageSize,function(err,result){
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});

/*
	status = 1
	finished = 1
	or 
	status = 1
	finished = 0
	indate < 当前时间
	然后按top降序   indate 降序
*/
router.get('/notice/oldAct', function(req, res, next) {
	var pageNo=req.query.pageNo,
    pageSize=req.query.pageSize,
	plate=req.query.plate,
    curdate = new Date(),
	_condition = {status:1,type:1,ent_code:req.session.user.ent_code,$or:[{indate:{$lt:curdate}},{finished:1}]},
	_sort = {top:-1,createtime:-1};
	if(plate){
		_condition.$or=[{plate:plate},{plate:null}];
	}else{
		_condition.plate=null;
	}
	queryList(_condition,_sort,pageNo,pageSize,function(err,result){
		if(err){
			return res.json(err);
		}
		return res.json(result);
	});
});

router.get('/notice/:id', function(req, res, next) {
	var id= req.params.id || req.query.id;
	if(!!!id){
		return res.json({err:'不存在的资源'});
	}
	Notice.findOne({_id:id,status:1},function(err,result){
		if(err){
			return res.json({err:err});
		}
		if(!!!result){
			return res.json({err:'不存在的资源'});
		}
		return res.json(result);
	});
});