'use strict';

var forumUserService=require('../service/forumUserService');

exports.getMobileUser=function(req){
	return req.session.mobileForumUser.userId;
	// return '55015675868b65a028187c49';
}

exports.getOpenId=function(req){
	return req.session.mobileForumUser.openId;
}

exports.identifyUser=function() {

	return function(req, res,next){
		if(!req.session.mobileForumUser){
			forumUserService.getUserByUid(req.session.openUser.openId,function(err,doc){
				if(err){
					next(err);
				}else{
					if(doc){
						req.session.mobileForumUser={
							userId:doc._id,
							openId:doc.uid
						};
						if(req.session.source){
							req.session.mobileForumUser.source = req.session.source;
							delete req.session.source;
						}
						next(null);
					}else{
						if(req.session.tmpOpenId){
							next(null);
						}else{
							req.session.tmpOpenId=req.session.openUser.openId;
							var entity={
								uid:req.session.openUser.openId,
								nickName:req.session.openUser.nickName,
								icon:req.session.openUser.headPic,
								ent_code:req.session.user.ent_code
							};
							forumUserService.createUser(entity,function(err,doc){
								if(err){
									next(null);
								}else{
									req.session.mobileForumUser={
										userId:doc._id,
										openId:doc.uid
									};
									if(req.session.source){
										req.session.mobileForumUser.source = req.session.source;
										delete req.session.source;
									}

									next(null);
								}
							});
						}
					}
				}
			});
		}else{
			if(req.session.source){
				req.session.mobileForumUser.source = req.session.source;
				delete req.session.source;
			}
			next(null);
		}
		
	}

}