'use strict';
var express = require('express'),
    router = express.Router(),
    _ = require('lodash'),
    then = require('thenjs'),
    mongoose = require('mongoose');

var forumThreadService = require('../../service/forumThreadService'),
    returnCode = require('../../utils/returnCode'),
    forumShareConfigService = require('../../service/forumShareConfigService'),
    forumShareService = require('../../service/forumShareService'),
    config = require('../../../config/config'),
    httpService=require('../../service/httpService'),
    forumInfoService = require('../../service/forumInfoService'),
    forumLimitActionRefService = require('../../service/forumLimitActionRefService');

module.exports = function(app) {
    app.use('/v1/forum', router);
};


function write(res, title, desc, link, imgUrl, mid, ent_code) {
    res.writeHead(200, {
        'Content-Type': 'text/javascript',
        'Cache-Control': 'no-cache',
        'Pragma': 'no-cache'
    });
    res.write('$(function(){');
    var success_singlemessage = '$.ajax({'+
                                 'type:\'GET\','+
                                 'url: \'/v1/forum/'+ent_code+'/share/singlemessage\''+
                            '});';
    var success_timeline = '$.ajax({'+
                                 'type:\'GET\','+
                                 'url: \'/v1/forum/'+ent_code+'/share/timeline\''+
                            '});';
    var string = 'wx.onMenuShareTimeline({' + '\"title\": \"' + title + '\",' + '\"link\":\"' + link + '\",' + '\"imgUrl\": \"' + imgUrl + '\", ' + 'success: function(){'+success_timeline+'},' + 'cancel: function () {}' + '    });' + 
                ' wx.onMenuShareAppMessage({' + '\"title\": \"' + title + '\", ' + '\"desc\": \"' + desc + '\", ' + '\"link\":\"' + link + '\", ' + '\"imgUrl\": \"' + imgUrl + '\", ' + '\"type\":\'\' ,' + '\"dataUrl\": \'\', ' + 'success: function(){'+success_singlemessage+'},' + 'cancel: function () { ' + '}' + '    });'

    res.write('wx.ready(function(){' + string + '});');
    res.write('wx.error(function(res){console.log(res);});');
    res.write('});');
    res.end();
}

function getWX(res, title, desc, link, imgUrl, mid,ent_code, id,type,forumThread) {
    //['{板块名称}','{文章标题}','{话题名称}','{照片墙标题}'];
    //share_type:是否使用默认设置:1使用默认分享设置  2.使用自己的分享设置
    link = config.service + link + "&mid=" + mid;
  
    if (type==="Info") {
        forumInfoService.getInfoById(id, function(err, forumInfo) {
            if (err || forumInfo < 1) {
                console.error("板块不存在或者发生未知错误");
                res.json({
                    message: '板块不存在或者发生未知错误',
                    result: false,
                    code: '10002',
                    error:err
                });
            }else{
                title = title.replace(/{板块名称}/g, forumInfo.name);
                desc = desc.replace(/{板块名称}/g, forumInfo.name);
                write(res, title, desc, link, imgUrl, mid,ent_code);
            }
        });  
    } else if(type === "Thread"){

        title = title.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.title);
        desc = desc.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.title);
        write(res, title, desc, link, imgUrl, mid,ent_code);
    } 
}

//微信分享接口
router.get('/:ent_code/share.js', function(req, res, next) {
    var rs = {},
        type = req.query.type,
        id = req.query.id,
        uId= req.session.mobileForumUser.userId,
        ent_code = req.params.ent_code,
        mid = 0,
        link = '/app/forum/' + ent_code + '/index?pageUrl=',
        share_log = {};
    if (req.session.openUser && req.session.openUser.mid) {
        mid = req.session.openUser.mid;
    }
    delete req.session.mobileForumUser.share_log;
    //板块微信接口
    if(!type || !id){
        console.error('请求参数错误')
        res.json(_.assign({result:false},returnCode.WRONG_PARAM));
    }else if (type === 'Info') {
        //分享记录对象
        share_log.type = 2;
        share_log.info = id;
		
		forumInfoService.getInfoById(id, function(err, forumInfo) {
            if (err) {
                console.error(err);
                res.json(_.assign({result:false},returnCode.BUSY));
				return;
            }
            if(forumInfo.share_type == 1){
                var shareInfo = forumInfo.share || {};
                var title = shareInfo.title || '',
                    desc = shareInfo.description || '',
                    imgUrl = shareInfo.icon || '';
                link = link + 'index&infoId='+ id+'&uId='+uId;
                getWX(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
                return;
			}else{
                 //默认分享设置 //查询板块默认分享设置
                forumShareConfigService.getByKey(ent_code, 'share', function(err, result) {
                    if(err){
                        console.error(err);
                        res.json(_.assign({result:false},returnCode.BUSY));
                    }else{
                        var title = '',desc = '',imgUrl = '';
                        if (result) {
                            //匹配板块默认分享设置
                            result = result.meta_value;
                            _.forEach(result,function(e){
                                if (e.type === 'info') {
                                    title = e.title;
                                    desc = e.desc;
                                    imgUrl = e.imgUrl;
                                    return;
                                }
                            });
                            link = link + 'index&infoId='+ id+'&uId='+uId;
                            getWX(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
                        }else{
                            //没找到板块默认分享设置
                            console.error('info默认分享设置不存在');
                            res.json(_.assign({result:false},returnCode.DATA_NOTEXITS));
                        }
                    }
                });
            }
           
        });
        
    }else if (type === 'Thread') {
        share_log.type = 3;
        share_log.thread = id;
        then(function(cont) {
            //获得文章
            forumThreadService.getById(id,cont);
        }).then(function(cont, thread) {
            if(!thread){
                //文章个性化分享设置不存在
                console.error('分享文章不存在');
                res.json(_.assign({result:false},returnCode.DATA_NOTEXITS));
            }else{
                share_log.p_thread = thread.pid;
                share_log.info = thread.info;
                share_log.thread_type = thread.pid?4:thread.type;
                //组装分享路径与判断分享类型
                //判断分享类型 1、文章 2、话题 3、照片墙
                var share_type = '';
                if (thread.type === 1 || (thread.type === 2 && thread.level === 2)) {
                    link = link + 'thread&infoId=' + thread.info + '&ent_code=' + ent_code + '&id=' + thread._id;
                    share_type = 'article';
                } else if (thread.type === 2 && thread.level === 1) {
                    link = link + 'topicList&infoId=' + thread.info + '&ent_code=' + ent_code + '&id=' + thread._id;
                    share_type = 'topic';
                } else if (thread.type === 3) {
                    link = link + 'photoList&infoId=' + thread.info + '&ent_code=' + ent_code + '&id=' + thread._id;
                    share_type = 'photo';
                }
                link  = link +'&uId='+uId;
                //获取分享设置
                if (!thread.share || thread.share_type==1) {
                    //获取默认文章分享设置
                    forumShareConfigService.getByKey(ent_code, 'share', function(err, sc) {
                        var title = '',desc = '',imgUrl = '';
                        if(err || !sc){
                            cont(err || share_type+'默认分享设置不存在');
                        }else{
                            sc = sc.meta_value;
                            //设置分享信息
                            _.forEach(sc,function(e){
                                if(share_type === e.type){
                                    title = e.title;
                                    desc = e.desc;
                                    imgUrl = e.imgUrl;
                                    return;
                                }
                            });
                            getWX(res, title, desc, link, imgUrl, mid,ent_code,thread._id,type,thread);
                        }
                    });
                } else {
                    //获取个性化文章分享设置
                    forumShareService.getById(thread.share, function(err, forumShare) {
                        if(err || !forumShare){
                            //文章个性化分享设置不存在
                            console.error(err || '文章个性化分享设置不存在');
                            res.json(_.assign({result:false},returnCode.DATA_NOTEXITS));
                        }else{
                            getWX(res, forumShare.title, forumShare.description, link, forumShare.icon, mid,ent_code,thread._id,type,thread);    
                        }
                    });
                }
            }
        }).fail(function(cont, err) {
            console.error(err);
            res.json(_.assign({result:false},returnCode.WRONG_PARAM));
        });
    }
    req.session.mobileForumUser.share_log = share_log;
});

//微信分享朋友圈接口
router.get('/:ent_code/share/timeline', function(req, res, next) {
    var mid = req.session.openUser.mid,
        action = 'share_timeline',
        ent_code = req.session.user.ent_code;

    var userId = req.session.mobileForumUser.userId;

    forumLimitActionRefService.checkLimitActionProhibitionAddIntegral(userId, function(err, flag){
        if(err){
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        }else{
            if(flag){
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            }else{
                httpService.createShareLog(req,1);    
                httpService.sendRequest(ent_code,mid,action);
                res.status(200).end();
            }
        }
    });
});

//微信分享单人接口
router.get('/:ent_code/share/singlemessage', function(req, res, next) {
    var mid = req.session.openUser.mid,
        action = 'share_singlemessage',
        ent_code = req.session.user.ent_code;  
    
    var userId = req.session.mobileForumUser.userId;
    forumLimitActionRefService.checkLimitActionProhibitionAddIntegral(userId, function(err, flag){
        if(err){
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        }else{
            if(flag){
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            }else{
                httpService.createShareLog(req,2);    
                httpService.sendRequest(ent_code,mid,action);
                res.status(200).end();
            }
        }
    });
});
