'use strict';
var mongoose = require('mongoose');
var ForumHonorTitle = mongoose.model('ForumHonorTitle');

//创建
exports.create=function(entity,callback){
	var forum = new ForumHonorTitle(entity);
	forum.save(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据ID获取
exports.getById=function(tid,callback){
	ForumHonorTitle.findById(tid, function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据ID更新
exports.updateById=function(tid,entity,callback){
	ForumHonorTitle.update({ _id: tid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID删除
exports.deleteById=function(tid,callback){
	ForumHonorTitle.remove({ _id: tid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumHonorTitle.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//分页查询
exports.getAll= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumHonorTitle.find(conditions, null, {skip:skip,limit:limit,sort:{order_idx:-1}},function(err,docs){
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};

//获取列表
exports.find=function(conditions,callback){
	ForumHonorTitle.find(conditions).sort({order_idx:-1}).exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs);
		}
    });
};

exports.getAllOrderIDX=function(conditions,callback){
	ForumHonorTitle.find(conditions).select('_id order_idx').sort({order_idx:-1}).exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs);
		}
	});
};

//修改序号
exports.updateIdx=function(id,idx,callback){
	ForumHonorTitle.update(
	{_id:id},
	{ order_idx: idx },
	null,
	function(err,result){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			callback(null,true);
		}
	});
};

