'use strict';
var mongoose = require('mongoose');
var ForumMessage = mongoose.model('ForumMessage');
var ForumUser = mongoose.model('ForumUser');
var _ = require('lodash');

//创建
exports.create=function(entity,callback){
	var forum = new ForumMessage(entity);
	forum.save(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据ID获取
exports.getById=function(tid,callback){
	ForumMessage.findById(tid, function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据条件更新
exports.update=function(condition,entity,callback){
	ForumMessage.update(condition, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID删除标签
exports.deleteById=function(tid,callback){
	ForumMessage.remove({ _id: tid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取消息and更新状态为已读
exports.findOneAndUpdate=function(condition,entity,callback){
	ForumMessage.findOneAndUpdate(condition, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,result);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumMessage.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//分页查询
exports.getAll= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
			ForumMessage.find(conditions).populate('from','uid nickName').skip(skip).limit(limit).sort({created:-1}).exec(function(err, docs) {
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};


//获取数量
function countTo(conditions,callback) {
	ForumMessage.findOne(conditions).select('to').exec(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,0);
		} else {
			var count = doc? doc.to.length:0;
			callback(null,count);
		}
	});
}

//分页查询
exports.getMessageTo= function(conditions,pageNo,pageSize,callback) {
	countTo(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumMessage.findOne(conditions).populate({
		        path: 'to',
		        options: {
		        	skip:skip,
		        	limit: limit,
		            sort: {created: -1}
		        }
		    }).select('to').exec(function(err, docs) {
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs.to;
					callback(null,obj);
				}
			});
		}
	});
};

//不分页查询To
exports.getMessageToNotPage= function(conditions,callback) {
	ForumMessage.findOne(conditions).select('to').exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs.to);
		}
	});
};


//-----------------------------前端 start-------------------------//

//获取用户的消息(不联查消息实体)
function getUserMessages(conditions,callback) {
	ForumUser.findOne(conditions).select('messages').exec(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc.messages);
		}
	});
}

//获取消息数组
exports.getMessages= function(conditions, status, pageNo, pageSize, callback) {
	ForumUser.findOne(conditions).select('messages').exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null,null);
		} else if(docs){
			var messages = [];
			if(docs.messages){
				for (var i = docs.messages.length - 1; i >= 0; i--) {
					if(docs.messages[i].status != status){
						messages.push(docs.messages[i]);
					}
				}
			}
			var total = messages.length;
			var skip = pageNo * pageSize;
		    var limit = total - skip > pageSize ? pageSize : (total - skip);
		    limit = parseInt(limit) + parseInt(skip);
			//获取分页后的数组
			messages = messages.slice(skip,limit); 
			callback(null,total,messages);
		}else{
			var messages = [];
			callback(null,0,messages);
		}
	});
};


//更新用户消息状态为已读
exports.updateUserMessageStatus= function(condition,msgID, status,callback) {
	getUserMessages(condition,function(err,docs){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			if(!msgID){  //更改全部
				for(var i = 0; i < docs.length; i++){
					if (docs[i].toObject) {
		                docs[i] = docs[i].toObject();
		            }
            		docs[i].status = status;
            	}
            } else { //更改单条
	            for(var i = 0; i < docs.length; i++){
	            	if (docs[i].msg == msgID) {
	                	if (docs[i].toObject) {
		                    docs[i] = docs[i].toObject();
		                }
	                    docs[i].status = status;
	                    break;
	                }
	            }
            }
            //更新用户
            ForumUser.update(condition, {messages:docs},null,function(err,result){
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					callback(null,null);
				}
			});
		}
	});
};


//前端根据ID获取
exports.getByIdWithSelect=function(mid,callback){
	ForumMessage.findOne({_id:mid}).select('_id fromNickName from title content created status').populate({
                path: 'from',
                select: 'nickName icon'
            }).exec(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//获取未读消息数量
exports.countUnReadMessage= function(conditions,callback) {
	ForumUser.findOne(conditions).populate({
        path: 'messages.msg',
        match: {'status':0},
        select: 'status'
    }).select('messages').exec(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,0);
		} else {
			var count = 0;
			_.forEach(doc.messages, function(msg, key) {
				if(msg.msg && msg.status == 0){
					count++;
				}
			});
			callback(null,count);
		}
	});
};

