'use strict';
var mongoose = require('mongoose');
var ForumRole = mongoose.model('ForumRole');

//创建论坛角色
exports.createRole=function(entity,callback){
	var forum = new ForumRole(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID获取论坛角色
exports.getRoleById=function(rid,callback){
	ForumRole.findById(rid, function(err, role) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,role);
		}
	});
};

//根据ID更新论坛角色
exports.updateRoleById=function(rid,entity,callback){
	ForumRole.update({ _id: rid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新论坛角色
exports.deleteRoleById=function(rid,callback){
	ForumRole.remove({ _id: rid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumRole.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAllRole= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumRole.find(conditions).skip(skip).limit(limit).sort('created').exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
		    });
		}
	});
};
