'use strict';
var mongoose = require('mongoose');
var ForumGroup = mongoose.model('ForumGroup');

//创建论坛组
exports.createGroup=function(entity,callback){
	var forum = new ForumGroup(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID更新论坛板块
exports.updateGroupById=function(gid,entity,callback){
	ForumGroup.update({ _id: fid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新论坛组
exports.deleteGroupById=function(gid,callback){
	ForumGroup.remove({ _id: gid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID获取论坛组
exports.getGroupById=function(gid,callback){
	ForumGroup.findById(gid, function(err, thread) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,thread);
		}
	});
};

//根据ID更新论坛组
exports.updateGroupById=function(gid,entity,callback){
	ForumGroup.update({ _id: gid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新论坛组
exports.deleteGroupById=function(gid,callback){
	ForumGroup.remove({ _id: gid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumGroup.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAll= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumGroup.find(conditions, null, {skip: skip,limit:limit,sort:'created'},function(err,docs){
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};
