'use strict';
// var request=require('request');

// var REMOTE_URL='http://127.0.0.1:3011/admin/forum/http/receive';
var ACTION_KEY = {
    'post': 'FORUM_THREAD_POST',
    'share': 'FORUM_THREAD_SHARE',
    'share_timeline': 'FORUM_THREAD_SHARE_TIMELINE',
    'comment': 'FORUM_THREAD_COMMENT',
    'thread_praise': 'FORUM_THREAD_PRAISE',
    'comment_praise': 'FORUM_COMMENT_PRAISE',
    'reply': 'FORUM_COMMENT_REPLY',
    'user_from_share': 'FORUM_USER_FROM_SHARE',
    'thread_recomment':'FORUM_THREAD_RECOMMENT'
};
var mongoose = require('mongoose'),
    moment = require('moment'),
    then  = require('thenjs');

var ForumPVLog = mongoose.model('ForumPVLog'),
    ForumUVLog = mongoose.model('ForumUVLog'),
    ForumShareLog = mongoose.model('ForumShareLog'),
    ForumThread = mongoose.model('ForumThread');
exports.sendRequest = function(ent_code, mid, action, messageid, integral, exp) {
    console.log('送积分了');
    var obj = {
        tag: 'member',
        key: 'forum',
        action: ACTION_KEY[action],
        mid: mid,
        entcode: ent_code,
        messageid: messageid || '',
        integral: integral || 0,
        exp: exp || 0
    };
    redis.lpush('adapter-redis-to-ons', JSON.stringify(obj), function(err, reply) {
        if (err) {
            console.error(err);
        }
    });
};

//推送文章记录
var sendThreadLogRequest = function(open_id, user_agent, origin_ip, method, nick_name, ent_code,mid,business_type,business_id,request_time,source_channel,source_open_id) {
    var obj = {
        "open_id":open_id,
        "user_agent":user_agent,
        "origin_ip":origin_ip,			//发起请求终端的ip地址
        "method":method,			//请求method
        "nick_name":nick_name,			//昵称，默认为会员名，如果没有则返回当前渠道的nick_name（如微信昵称）
        "ent_code":ent_code,			//企业号
        "mid":mid,
        "business_type":business_type,		//业务分类，用于标识不同的业务类型（如news,forum等）
        "business_id":business_id?business_id:null,		//业务记录的唯一标识，如news_id等
        "request_time":request_time || new Date(),		//发起请求的时间
        "source_channel":source_channel,	//分享入口渠道(0：官方直接分享；1：微信朋友圈；2：微信好友；3：QQ好友；4：腾讯微博；5：广告组；6：自媒体；)
        "source_open_id":source_open_id		//分享人的open_id
    };
    redis.publish('__pi_front_access_log_old__', JSON.stringify(obj), function(err, reply) {
        if (err) {
            console.error(err);
        }
    });
};

var getClientIP = function(req) {
    var ipAddress;
    var headers = req.headers;
    var forwardedIpsStr = headers['remoteip'] ||  headers['x-real-ip'] || headers['x-forwarded-for'];
    if (forwardedIpsStr) {
        ipAddress = forwardedIpsStr;
    } else {
        ipAddress = null;
    }
    if (!ipAddress) {
        ipAddress = req.connection.remoteAddress;
    }
    return ipAddress;
};

exports.createLog = function(req,source,info,type,thread_type,thread,p_thread) {
    var logObj = {
        ent_code: req.session.user.ent_code,
        source:source,
        mid: req.session.openUser.mid,
        open_id: req.session.mobileForumUser.openId,
        user: req.session.mobileForumUser.userId,
        info: info,
        type: type,
        thread_type:thread_type,
        thread:thread,
        p_thread:p_thread,
        ip: getClientIP(req),
        userAgent: req.headers['user-agent']
    };
    //推送
    sendThreadLogRequest(
        req.session.openUser.openId,
        req.headers['user-agent'],
        getClientIP(req),
        null,
        req.session.openUser.nickName,
        req.session.user.ent_code,
        req.session.openUser.mid,
        'forum.'+info,
        thread,
        null,
        null,
        null
    );


    if (logObj) {
        then(function(cont){
            var pv_model = new ForumPVLog(logObj);
            pv_model.save(cont);
        }).then(function(cont){
            var q = {
                created:{$gte:moment(new Date()).format('YYYY-MM-DD')},
                mid:logObj.mid,
                openId:logObj.openId,
                user:logObj.user,
                info:logObj.info
            };
            if(logObj.thread){
                q.thread = logObj.thread;
                q.thread_type = logObj.thread_type;
            }
            ForumUVLog.findOne(q,function(err,doc){
                cont(err,doc?false:true);
            })
        }).then(function(cont,isLog){
            if(isLog){
                var uv_model = new ForumUVLog(logObj);
                uv_model.save();
            }
        }).fail(function(cont,err){
            console.error(err);
        });
    } else {
        console.error('没有日志信息');
    }
};

exports.createShareLog = function(req,share_type) {
    var logObj = req.session.mobileForumUser.share_log;
    logObj.source = req.session.mobileForumUser.source;
    logObj.mid = req.session.openUser.mid;
    logObj.ent_code = req.session.user.ent_code;
    logObj.user = req.session.mobileForumUser.userId;
    logObj.open_id = req.session.mobileForumUser.openId;
    logObj.ip = getClientIP(req);
    logObj.share_type = share_type;
    logObj.userAgent = req.headers['user-agent'];
    if(logObj){
        then(function(cont){
            var share_log_model = new ForumShareLog(logObj);
            share_log_model.save(function(err){
                cont(err);
            });
        }).then(function(cont){
            if(logObj.thread){
                ForumThread.update({_id:logObj.thread},{$inc:{share_count:1}},function(err){
                    cont(err);
                });
            }
        }).fail(function(cont,err){
            console.error(err);
        });
    }

};
