'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash'),
    then = require('thenjs'),
    moment = require('moment'),
    mongoose = require('mongoose');
var async = require('async');
//模型
var ForumPvLog = mongoose.model('ForumPVLog'),
    ForumUvLog = mongoose.model('ForumUVLog'),

    ForumPraiseLog = mongoose.model('ForumPraiseLog'),
    ForumShareLog = mongoose.model('ForumShareLog'),
    ForumComment = mongoose.model('ForumComment'),
    ForumUserThreadControl = mongoose.model('ForumUserThreadCotrol'),

    ForumUser = mongoose.model('ForumUser'),

    ForumThread = mongoose.model('ForumThread');

module.exports = function(app) {
    app.use('/admin/forum', router);
};
var aggregate = function(model, match, group_id, sort, callback) {
    model.aggregate({
            $match: match
        }, {
            $group: {
                _id: group_id,
                count: {
                    $sum: 1
                }
            }
        }, {
            $sort: sort
        },
        function(err, docs) {
            callback(err, docs);
        });
}


//格式化日期 (格式：年-月-日)
function date_format(date) {
    return moment(date).format('YYYY/MM/DD');
}

//获取日期之间所有日期
function get_all_date(begin, end) {
    var date_array = [];
    // if (begin === end) return date_array;
    if (begin === end){
        date_array.push(end.replace(/-/g, "/"));
        return date_array;
    } 
    var ab = begin.split('-');
    var ae = end.split('-');
    var db = new Date();
    db.setUTCFullYear(ab[0], ab[1] - 1, ab[2]);
    var de = new Date();
    de.setUTCFullYear(ae[0], ae[1] - 1, ae[2]);
    var unixDb = db.getTime();
    var unixDe = de.getTime() + 24 * 60 * 60 * 1000;
    for (var k = unixDb; k < unixDe;) {
        date_array.push(date_format(new Date(parseInt(k))));
        k = k + 24 * 60 * 60 * 1000;
    }
    return date_array;
}

//统计
function mapReduce(model, match, group, date, callback) {
    model.aggregate({
            $match: match
        }, {
            $group: group
        },
        function(err, res) {
            if (err) callback(err);
            else {
                var data = {
                    date: date,
                    count: res.length
                };
                callback(null, data);
            }
        });
}


//统计
function countSex(t_id, sex, callback) {
    ForumUvLog.find({ //men
        'thread': t_id
    }).populate({
        path: 'user',
        match: {
            'sex': sex
        }
    }).exec(function(err, res) {
        if (err) callback(err);
        else {
            callback(null, res.length);
        }
    });
}



//社区情况(首页)
    router.get('/statistic', function(req, res, next) {
    var yesterday = moment(new Date().getTime() - 24 * 3600 * 1000).format('YYYY-MM-DD'),
        before_yesterday = moment(new Date().getTime() - 2 * 24 * 3600 * 1000).format('YYYY-MM-DD');
    var ent_code = req.session.user.ent_code,
        y_begin = new Date(yesterday), //昨天开始时间
        y_end = new Date(yesterday + ' 23:59:59'), //昨天结束时间
        by_begin = new Date(before_yesterday), //前天开始时间
        by_end = new Date(before_yesterday + ' 23:59:59'); //前天结束时间
    then.parallel([
        function(cont) {
            //昨天访问用户
            var match = {
                ent_code: ent_code,
                created: {
                    $gte: y_begin,
                    $lte: y_end
                }
            };
            aggregate(ForumUvLog, match, {
                mid: '$mid'
            }, {
                'count': -1
            }, function(err, docs) {
                cont(err, docs.length);
            });
        },
        function(cont) {
            //前天访问用户
            var match = {
                ent_code: ent_code,
                created: {
                    $gte: by_begin,
                    $lte: by_end
                }
            };
            aggregate(ForumUvLog, match, {
                mid: '$mid'
            }, {
                'count': -1
            }, function(err, docs) {
                cont(err, docs.length);
            });
        },
        function(cont) {
            //昨天发帖数
            var match = {
                ent_code: ent_code,
                created: {
                    $gte: y_begin,
                    $lte: y_end
                }
            };
            ForumThread.count(match, function(err, count) {
                cont(err, count);
            });
        },
        function(cont) {
            //前天发帖数
            var match = {
                ent_code: ent_code,
                created: {
                    $gte: by_begin,
                    $lte: by_end
                }
            };
            ForumThread.count(match, function(err, count) {
                cont(err, count);
            });
        },
        function(cont) {
            //总访问用户
            var match = {
                ent_code: ent_code
            };
            aggregate(ForumUvLog, match, {
                mid: '$mid'
            }, {
                'count': -1
            }, function(err, docs) {
                cont(err, docs.length);
            });
        },
        function(cont) {
            //总发帖数
            var match = {
                ent_code: ent_code
            };
            ForumThread.count(match, function(err, count) {
                cont(err, count);
            });
        }
    ]).then(function(cont, datas) {
        var y_user = datas[0],
            by_user = datas[1],
            y_thread = datas[2],
            by_thread = datas[3],
            all_user = datas[4],
            all_thread = datas[5];
        //计算昨天比前天多 多少 的百分比
        var user_rate = (by_user === 0) ? y_user : (y_user / by_user).toFixed(4) - 1,
            thread_rate = (by_thread === 0) ? y_thread : (y_thread / by_thread).toFixed(4) - 1;
        cont(null, y_user, user_rate, y_thread, thread_rate, all_user, all_thread);
    }).then(function(cont, y_user, user_rate, y_thread, thread_rate, all_user, all_thread) {
        //返回数据
        res.json({
            result: true,
            data: {
                user: y_user,
                user_rate: Math.round(user_rate > 1 ? 100 : user_rate < 0 ? 0 : user_rate * 100),
                thread: y_thread,
                thread_rate: Math.round(thread_rate > 1 ? 100 : thread_rate < 0 ? 0 : thread_rate * 100),
                all_user: all_user,
                all_thread: all_thread
            }
        })
    }).fail(function(cont, err) {
        console.error(err);
        res.json({
            result: false,
            err: err
        });
    });
});

//文章浏览统计
router.post('/getThreadViewStatistic', function(req, res, next) {
    // 1.获取文章的创建日期,和今天的日期,转换成日期数组
    var t_id = req.body.t_id;
    var begin_time = req.body.beginDate;
    var ent_time = req.body.endDate;
    var all_data_array = get_all_date(begin_time, ent_time);

    // 2.根据数组统计PV,UV,行为
    if (begin_time && ent_time) {
        var pv_datas = [];
        var uv_datas = [];
        // var thread_datas = [];

        var pv_tasks = [];
        _.forEach(all_data_array, function(d) {
            //统计所有PV
            pv_tasks.push(function(cont) {
                var match = {
                    thread: t_id,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumPvLog, match, group, d, cont);
            });
        });

        var uv_tasks = [];
        _.forEach(all_data_array, function(d) {
            //统计所有UV
            uv_tasks.push(function(cont) {
                var match = {
                    thread: t_id,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        user: '$user'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumUvLog, match, group, d, cont);
            });
        });

        then.parallel([function(con) {
            //pv
            then.parallel(pv_tasks).then(function(cont, datas) {
                pv_datas = datas;
                con();
            }).fail(function(cont, err) {
                con();
            });
        }, function(con) {
            //uv
            then.parallel(uv_tasks).then(function(cont, datas) {
                uv_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }]).then(function(cont, datas) {
            res.json({
                result: true,
                errcode: 0,
                pv_datas: pv_datas,
                uv_datas: uv_datas
            });
        }).fail(function(cont, err) {
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});


//文章行为统计
router.post('/getThreadActionStatistic', function(req, res, next) {
    // 1.获取文章的创建日期,和今天的日期,转换成日期数组
    var t_id = req.body.t_id,
        ent_code = req.session.user.ent_code,
        begin_time = req.body.beginDate,
        ent_time = req.body.endDate,
        all_data_array = get_all_date(begin_time, ent_time);

    // 2.根据数组统计PV,UV,行为
    if (begin_time && ent_time) {
        var userThreadControl_datas = [];
        var praise_datas = [];
        var comment_datas = [];
        var share_datas = [];

        //统计所有屏蔽
        var userThreadControl_tasks = [];
        _.forEach(all_data_array, function(d) {
            userThreadControl_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    },
                    thread: {
                        $elemMatch: {
                            $in: [t_id]
                        }
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumUserThreadControl, match, group, d, cont);
            });
        });

        //统计所有点赞
        var praise_tasks = [];
        _.forEach(all_data_array, function(d) {
            praise_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    thread: new mongoose.Types.ObjectId(t_id),
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumPraiseLog, match, group, d, cont);
            });
        });

        //统计所有评论
        var comment_tasks = [];
        _.forEach(all_data_array, function(d) {
            comment_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    thread: new mongoose.Types.ObjectId(t_id),
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumComment, match, group, d, cont);
            });
        });

        //统计所有分享
        var share_tasks = [];
        _.forEach(all_data_array, function(d) {
            share_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    thread: t_id,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumShareLog, match, group, d, cont);
            });
        });

        then.parallel([function(con) {
            //屏蔽
            then.parallel(userThreadControl_tasks).then(function(cont, datas) {
                userThreadControl_datas = datas;
                con();
            }).fail(function(cont, err) {
                con();
            });
        }, function(con) {
            //点赞
            then.parallel(praise_tasks).then(function(cont, datas) {
                praise_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }, function(con) {
            //评论
            then.parallel(comment_tasks).then(function(cont, datas) {
                comment_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }, function(con) {
            //分享
            then.parallel(share_tasks).then(function(cont, datas) {
                share_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }]).then(function(cont, datas) {
            var data = {
                userThreadControl_datas: userThreadControl_datas,
                praise_datas: praise_datas,
                comment_datas: comment_datas,
                share_datas: share_datas
            }

            res.json({
                result: true,
                errcode: 0,
                data: data,
                dates: all_data_array
            });
        }).fail(function(cont, err) {
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});

//文章性别统计
router.post('/getThreadSexStatistic', function(req, res, next) {
    // 1.获取文章的创建日期,和今天的日期,转换成日期数组
    var t_id = req.body.t_id;

    var men = 0;
    var women = 0;
    var unkown = 0;
    var data = {};
    if (t_id) {
        then(function(cont) {
            ForumUvLog.find({
                'thread': t_id
            }).populate('user').exec(function(err, docs) {
                if (err) cont(err);
                else {
                    var uniqueList = _.uniq(docs, function(item) {
                        return item.user._id;
                    });
                    for (var i = 0; i < uniqueList.length; i += 1) {
                        var thread = uniqueList[i];
                        switch (thread.user.sex) {
                            case 1:
                                men = men + 1;
                                break;
                            case 2:
                                women = women + 1;
                                break;
                            default:
                                unkown = unkown + 1;
                                break;
                        }
                    }
                    var all = men + women + unkown;
                    data = {
                        men: (men / all),
                        women: (women / all),
                        unkown: 1 - (men / all) - (women / all)
                    };
                    cont(null, data);
                }
            });
        }).then(function(cont, data) {
            res.json({
                result: true,
                errcode: 0,
                data: data
            });
        }).fail(function(cont, err) {
            console.error('err');
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});
