'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');

var forumRoleService=require('../../service/forumRoleService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增论坛角色
router.post('/role/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumRoleService.createRole(req.body,function(err,forum){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = forum;
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//删除论坛角色
router.get('/role/:rid/get', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumRoleService.getRoleById(rid,function(err,role){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				var rs = {};
				rs.data=role;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//删除论坛角色
router.post('/role/:rid/delete', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumRoleService.deleteRoleById(rid,function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//更新论坛角色
router.post('/role/:rid/update', function(req, res, next) {
	var rid=req.params.rid;
	if(rid){
		forumRoleService.updateRoleById(rid,req.body,function(err,result){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取角色列表
router.get('/role/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var roleName=req.query.roleName;

    var conditions={
    	ent_code:req.session.user.ent_code,
    	status:1
    };
    if(roleName){
    	conditions.title={
    		$regex: roleName,
			$options: 'i'
    	};
    }

    forumRoleService.getAllRole(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});
