'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//黑名单
var BlackListSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	blackOpenId:{//被加入黑名单的openid
		type: String,
		require: false,
		index: true
	},
	blackUser: { //被加入黑名单的user
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumUser'
	},
	reason: { //加入黑名单的原因
		type: String,
		require: false
	},
	
	begin: {//黑名单有效时间
		type: Date,
		require: false
	},
	end: {//黑名单有效时间
	    type: Date,
	    required: false 
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	},
	status:{//是否可用 1/0
		type: Number,
		require: true,
		index: true,
		default:1
	}
}, {
	'collection': 'pisns_forum_blacklist'
});

module.exports = mongoose.model('BlackList', BlackListSchema);