'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;

//收藏的帖子
var ForumFollowThreadSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	thread: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumThread'
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_follow_thread'
});

module.exports = mongoose.model('ForumFollowThread', ForumFollowThreadSchema);