'use strict';

var mongoose = require('mongoose'),
    Schema = mongoose.Schema;
//行为限制表
var ForumLimitOperationSchema = new Schema({
    ent_code: {
        type: Number,
        index: true,
        require: true
    },
    userId: { //forumUser id
        type: String,
        index: true,
        unique:true,
        require: true
    },
    uid: { //用户ID，这里直接存放用户的openId
        type: String,
        require: false
    },
    status: { //状态，1启用，0禁用
        type: Number,
        require: true,
        default: 1
    },
    limit_actions: [{
        limit_reason: { //原因
            type: String,
            default: ''
        },
        limit_type: {  //限制类型, 1 禁言, 2 不加积分
            type: Number,
            default: 0
        },
        begin_time: { //开始时间
            type: Date
        },
        end_time: { //结束时间
            type: Date
        },
        days:{   //限制天数
            type: Number,
            require: false
        }
    }],
    created: {
        type: Date,
        required: true,
        default: Date.now
    }
}, {
    'collection': 'pisns_forum_limit_operation'
});


module.exports = mongoose.model('ForumLimitOperation', ForumLimitOperationSchema);
