'use strict';

var redis=global.redis;
var prefix = '_forum_floor_generator_';
var expire = 60 * 30;//半个小时

var forumCommentService = require('../service/forumCommentService');

function getKey(entcode,id){
    return entcode + prefix + id;
}

/*
 获取帖子的评论的楼层
 tid:帖子id
 */
exports.getCommentFloor=function(entcode,tid,callback){
    var key = getKey(entcode,tid);
    if(!redis){
        console.log('redis error');
        return callback && callback('redis error');
    }
    redis.get(key, function(error, floor){//先判断楼层计数器是否存在
        if(error){
            return callback && callback(error);
        }
        if(floor){//存在，就直接累加
            redis.incr(key, function(error, newfloor){
                if(error){
                    return callback && callback(error);
                }
                redis.expire(key, expire);
                return callback && callback(error, newfloor || 1);
            });
        }else{//不存在
            redis.watch(key);
            var multi = redis.multi();
            //获取评论的最新楼层
            forumCommentService.count({
                thread: tid,
                level: '1'
            }, function(err, count) {
                if (err) {
                    multi.discard();
                    return callback && callback(err);
                }
                var newfloor = (count || 0) + 1;
                multi.set(key,newfloor);
                multi.exec(function(err,replies){
                    if (err) {
                        return callback && callback(err);
                    }
                    redis.expire(key, expire);
                    return callback && callback(null,newfloor);
                })
            });
        }
    });
};