'use strict';

var _ = require('lodash');
var request = require('request');
var env = process.env.NODE_ENV;
var API_ADDRESS = 'http://localhost:8080';
if (env == 'sandbox') {
    API_ADDRESS = 'http://rest.wxpai.cn';
} else if (env == 'production') {
    API_ADDRESS = 'https://rest.wxpai.cn';
}

exports.loadLevel=function(ent_code,items,callback){
    var openIds = [];
    _.forEach(items, function(d, i) {
        if(d.from && d.from.uid){
            openIds.push(d.from.uid);
        }
        if(d.to && d.to.uid){
            openIds.push(d.to.uid);
        }
        if(d.commentLevel1From && d.commentLevel1From.uid){
            openIds.push(d.commentLevel1From.uid);
        }
        if(d.commentLevel2From && d.commentLevel2From.uid){
            openIds.push(d.commentLevel2From.uid);
        }
        if(d.commentLevel2ThreadFrom && d.commentLevel2ThreadFrom.uid){
            openIds.push(d.commentLevel2ThreadFrom.uid);
        }
    });

    request.post({
        url: API_ADDRESS + '/v1.0/internal/member/list/byopenids',
        json: {
            "entCode": ent_code,
            "openIds": openIds
        }
    }, function(e, r, body) {
        if (body && body.data) {
            _.forEach(items, function(d, i) {
                if (items[i].toObject) {
                    items[i] = items[i].toObject();
                }
                _.forEach(body.data, function(r, j) {
                    if(d.from && d.from.uid === r.user.openId){
                        items[i].from.exp = r.exp;
                    }
                    if(d.to && d.to.uid === r.user.openId){
                        items[i].to.exp = r.exp;
                    }
                    if(d.commentLevel1From && d.commentLevel1From.uid === r.user.openId){
                        items[i].commentLevel1From.exp = r.exp;
                    }
                    if(d.commentLevel2From && d.commentLevel2From.uid === r.user.openId){
                        items[i].commentLevel2From.exp = r.exp;
                    }
                    if(d.commentLevel2ThreadFrom && d.commentLevel2ThreadFrom.uid === r.user.openId){
                        items[i].commentLevel2ThreadFrom.exp = r.exp;
                    }
                });

                if(d.from && !items[i].from.exp){
                    items[i].from.exp = 0;
                }
                if(d.to && !items[i].to.exp){
                    items[i].to.exp = 0;
                }
                if(d.commentLevel1From && !items[i].commentLevel1From.exp){
                    items[i].commentLevel1From.exp = 0;
                }
                if(d.commentLevel2From && !items[i].commentLevel2From.exp){
                    items[i].commentLevel2From.exp = 0;
                }
                if(d.commentLevel2ThreadFrom && !items[i].commentLevel2ThreadFrom.exp){
                    items[i].commentLevel2ThreadFrom.exp = 0;
                }
            });
        }
        return callback && callback();
    });
};

exports.loadLevelByUser=function(ent_code,items,callback){
    var openIds = [];
    _.forEach(items, function(d, i) {
        if(d.uid){
            openIds.push(d.uid);
        }
    });

    request.post({
        url: API_ADDRESS + '/v1.0/internal/member/list/byopenids',
        json: {
            "entCode": ent_code,
            "openIds": openIds
        }
    }, function(e, r, body) {
        if (body && body.data) {
            _.forEach(items, function(d, i) {
                if (items[i].toObject) {
                    items[i] = items[i].toObject();
                }
                _.forEach(body.data, function(r, j) {
                    if(d.uid === r.user.openId){
                        items[i].exp = r.exp;
                    }
                });

                if(!items[i].exp){
                    items[i].exp = 0;
                }
            });
        }
        return callback && callback();
    });
};