'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题评论
var ForumCommentSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { //评论人
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	to: { //回复人
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	comments: { //评论的评论
		type.Array
	},
	content: { //评论内容
		type: String,
		require: true
	},
	ip: { //IP地址
		type: String,
		require: true
	},
	created: { //评论时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_comment'
});


module.exports = mongoose.model('ForumComment', ForumCommentSchema);