'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//论坛分类定义
var ForumGroupSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	name: { //分类名称
		type: String,
		require: true
	},
	icon: { //分类图标
		type: String,
		require: true
	},
	order_idx: { //分类排序
		type: Number,
		require: true,
		default: 0
	},
	status: { //分类状态，1启用，0禁用
		type: Number,
		require: true,
		default: 1
	}

}, {
	'collection': 'pisns_forum_group'
});


module.exports = mongoose.model('ForumGroup', ForumGroupSchema);