'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//点赞日志
var ForumPraiseLogSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	user: { //点赞者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	thread: { //点赞话题
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumThread'
	},
	ip: { //IP地址
		type: String,
		require: true
	},
	created: { //点赞时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_praise_log'
});

module.exports = mongoose.model('ForumPraiseLog', ForumPraiseLogSchema);